<?php

class AdminManager extends Base {

    public static function index($page) {

        if (parent::admin()) {

            $p = Flight::page();

            $p->menu('video', '/admin/manager', $page);

            $list = Flight::db()->query("SELECT * FROM `video` ORDER BY id DESC ".$p->limit() . "")->fetchAll();

            parent::view('admin/manager_list', [
                'title' => 'Менеджер файлов',
                'list' => $list,
                'pagination' => $p->menu('video', '/admin/manager', $page),
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

    public static function edit($id) {
        
        $id = abs((int)$id);
        
        if (parent::admin()) {

            $errors = array();

            $video = Flight::db()->query("SELECT * FROM `video` WHERE `id` = {$id}")->fetch();
            $cat = Flight::db()->query("SELECT * FROM `category`")->fetchAll();
            
            //echo '<pre>', print_r($video), '</pre>';

            if (parent::isMethod('POST')) {
                
                $name = (parent::data('name')) ? parent::data('name') : '';
                $about = (parent::data('about')) ? parent::data('about') : '';
                $url = (parent::data('url')) ? parent::data('url') : '';
                $keywords = (parent::data('keywords')) ? parent::data('keywords') : '';
                $description = (parent::data('description')) ? parent::data('description') : '';
                $catid = (parent::data('cat')) ? parent::data('cat') : '';

                if (empty($name))
                    $errors[] = 'Имя не заполнено';
                if (empty($url))
                    $errors[] = 'URL не заполнен';

                if ( ! $errors) {
                    
                    $sql = "
                        UPDATE `video` SET
                        `name` = :name,
                        `description` = :description,
                        `keywords` = :keywords,
                        `url` = :url,
                        `about` = :about,
                        `catid` = :catid
                        WHERE `id` = {$id}
                    ";
                    
                    $result = Flight::db()->prepare($sql);
                    $result->bindValue(":name", $name, PDO::PARAM_STR);
                    $result->bindValue(":description", $description, PDO::PARAM_STR);
                    $result->bindValue(":keywords", $keywords, PDO::PARAM_STR);
                    $result->bindValue(":about", $about, PDO::PARAM_STR);
                    $result->bindValue(":url", $url, PDO::PARAM_STR);
                    $result->bindValue(":catid", $catid, PDO::PARAM_INT);
                    $result->execute(); 

                    $errors[] = 'Видео успешно изменено';

                }

            }

            parent::view('admin/video_edit', [
                'title' => 'Изменить видео',
                'errors' => $errors,
                'video' => $video,
                'list' => $cat,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

    public static function delete($id) {
        
        $id = abs((int)$id);
        
        if (parent::admin()) {

            $root = $_SERVER['DOCUMENT_ROOT'];

            $video = Flight::db()->query("SELECT * FROM `video` WHERE `id` = {$id}")->fetch();

            @unlink($root . '/public/video/' . $video['filename'] . '.mp4');
            @unlink($root . '/public/video/' . $video['filename'] . '.3gp');
            @unlink($root . '/public/screen/' . $video['screen'] . '.png');

            Flight::db()->query("DELETE FROM `video` WHERE `id` = {$id}");
            Flight::redirect(Flight::request()->referrer);

        } else Flight::redirect('/admin');

    }

}