<?php

class AdminFiles extends Base {

    public static function upload() {

        if (parent::admin()) {

            $errors = array();

            $list = Flight::db()->query("SELECT * FROM `category`")->fetchAll();

            if (parent::isMethod('POST')) {
                
                //echo '<pre>', print_r($_FILES), '</pre>';
               
               
                $root = $_SERVER['DOCUMENT_ROOT'];
        
                $file_mp4 = (parent::files('mp4')) ? parent::files('mp4') : '';
                $file_3gp = (parent::files('3gp')) ? parent::files('3gp') : '';
                $name = (parent::data('name')) ? parent::data('name') : '';
                $about = (parent::data('about')) ? parent::data('about') : '';
                $description = (parent::data('description')) ? parent::data('description') : '';
                $keywords = (parent::data('keywords')) ? parent::data('keywords') : '';
                $url = (parent::data('url')) ? parent::data('url') : '';
                $cat = (parent::data('cat')) ? parent::data('cat') : '';
                
                if (empty($name))
                    $errors[] = 'Заполните имя для файла';
                if (empty($url))
                    $errors[] = 'Заполните URL для файла';

                if ( ! $errors) {

                    $filename = PREFIX.time();

                    $sizing_mp4 = null;
                    $sizing_3gp = null;
                    
                    $size_mp4 = null;
                    $size_3gp = null;
                    
                    if ($file_mp4 && !empty($file_mp4['name'])) {
                        move_uploaded_file($file_mp4['tmp_name'], $root . '/public/video/' . $filename . '.mp4');
                        $size_mp4 = @filesize($root . '/public/video/' . $filename . '.mp4');
                    }

                    if ($file_3gp && !empty($file_3gp['name'])) {
                        move_uploaded_file($file_3gp['tmp_name'], $root . '/public/video/' . $filename . '.3gp');
                        $size_3gp = @filesize($root . '/public/video/' . $filename . '.3gp');
                    }

                    if ($file_mp4 && !empty($file_mp4['name'])) {
                        $movie = new ffmpeg_movie($root . '/public/video/' . $filename . '.mp4');
                        $sizing_mp4 = $movie->getFrameHeight().'x'.$movie->getFrameWidth();
                    }
                    else {
                        $movie = new ffmpeg_movie($root . '/public/video/' . $filename . '.3gp');
                        $sizing_3gp = $movie->getFrameHeight().'x'.$movie->getFrameWidth();
                    }

                    $frame = 25;

                    $img_path = $root . '/public/screen/'.$filename.'.png';

                    $image = $movie->getFrame($frame);
                    $selfimg = $image->toGDImage();

                    imagepng($selfimg, $img_path);
                    imagedestroy($selfimg);

                    parent::resize($img_path, $img_path, 175, 144);
                    parent::watermark($img_path, $img_path);

                    $duration = $movie->getDuration();
                    
                    $sql = "
                      INSERT INTO `video` SET
                      `catid`       = :cat,
                      `name`        = :name,
                      `description` = :description,
                      `keywords`    = :keywords,
                      `about`       = :about,
                      `filename`    = '{$filename}',
                      `screen`      = '{$filename}',
                      `duration`    = '{$duration}',
                      `sizing_mp4`  = '{$sizing_mp4}',
                      `sizing_3gp`  = '{$sizing_3gp}',
                      `size_mp4`    = '{$size_mp4}',
                      `size_3gp`    = '{$size_3gp}',
                      `url`         = :url,
                      `date_upload` = UNIX_TIMESTAMP()
                    ";
                    
                    $result = Flight::db()->prepare($sql);
                    $result->bindValue(":cat", $cat, PDO::PARAM_STR);
                    $result->bindValue(":name", $name, PDO::PARAM_STR);
                    $result->bindValue(":description", $description, PDO::PARAM_STR);
                    $result->bindValue(":keywords", $keywords, PDO::PARAM_STR);
                    $result->bindValue(":about", $about, PDO::PARAM_STR);
                    $result->bindValue(":url", $url, PDO::PARAM_STR);
                    $result->execute(); 

                    $errors[] = 'Видео успешно загружено';

                }

            }

            parent::view('admin/upload', [
                'title' => 'Upload файлов',
                'errors' => $errors,
                'list' => $list,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

    public static function import() {

        if (parent::admin()) {

            $errors = array();

            $list = Flight::db()->query("SELECT * FROM `category`")->fetchAll();

            if (parent::isMethod('POST')) {

                $root = $_SERVER['DOCUMENT_ROOT'];

                $file_mp4 = (parent::data('mp4')) ? parent::data('mp4') : '';
                $file_3gp = (parent::data('3gp')) ? parent::data('3gp') : '';
                $name = (parent::data('name')) ? parent::data('name') : '';
                $about = (parent::data('about')) ? parent::data('about') : '';
                $description = (parent::data('description')) ? parent::data('description') : '';
                $keywords = (parent::data('keywords')) ? parent::data('keywords') : '';
                $url = (parent::data('url')) ? parent::data('url') : '';
                $cat = (parent::data('cat')) ? parent::data('cat') : '';

                if (empty($name))
                    $errors[] = 'Заполните имя для файла';
                if (empty($url))
                    $errors[] = 'Заполните URL для файла';

                if ( ! $errors) {

                    $filename = PREFIX.time();

                    $sizing_mp4 = null;
                    $sizing_3gp = null;

                    $size_mp4 = null;
                    $size_3gp = null;

                    if ($file_mp4) {
                        @copy($file_mp4, $root . '/public/video/' . $filename . '.mp4');
                        $size_mp4 = @filesize($root . '/public/video/' . $filename . '.mp4');
                    }

                    if ($file_3gp) {
                        @copy($file_3gp, $root . '/public/video/' . $filename . '.3gp');
                        $size_3gp = @filesize($root . '/public/video/' . $filename . '.3gp');
                    }

                    if ($file_mp4) {
                        $movie = new ffmpeg_movie($root . '/public/video/' . $filename . '.mp4');
                        $sizing_mp4 = $movie->getFrameWidth().'x'.$movie->getFrameHeight();
                        if($file_3gp) {
                            $movie2 = new ffmpeg_movie($root . '/public/video/' . $filename . '.3gp');
                            $sizing_3gp = $movie2->getFrameWidth() . 'x' . $movie2->getFrameHeight();
                        }
                    }
                    else {
                        $movie = new ffmpeg_movie($root . '/public/video/' . $filename . '.3gp');
                        $sizing_3gp = $movie->getFrameWidth().'x'.$movie->getFrameHeight();
                    }

                    $frame = 25;

                    $img_path = $root . '/public/screen/'.$filename.'.png';

                    $image = $movie->getFrame($frame);
                    $selfimg = $image->toGDImage();

                    imagepng($selfimg, $img_path);
                    imagedestroy($selfimg);

                    parent::resize($img_path, $img_path, 175, 144);
                    parent::watermark($img_path, $img_path);

                    $duration = $movie->getDuration();

                    $sql = "
                      INSERT INTO `video` SET
                      `catid`       = :cat,
                      `name`        = :name,
                      `description` = :description,
                      `keywords`    = :keywords,
                      `about`       = :about,
                      `filename`    = '{$filename}',
                      `screen`      = '{$filename}',
                      `duration`    = '{$duration}',
                      `sizing_mp4`  = '{$sizing_mp4}',
                      `sizing_3gp`  = '{$sizing_3gp}',
                      `size_mp4`    = '{$size_mp4}',
                      `size_3gp`    = '{$size_3gp}',
                      `url`         = :url,
                      `date_upload` = UNIX_TIMESTAMP()
                    ";
                    
                    $result = Flight::db()->prepare($sql);
                    $result->bindValue(":cat", $cat, PDO::PARAM_STR);
                    $result->bindValue(":name", $name, PDO::PARAM_STR);
                    $result->bindValue(":description", $description, PDO::PARAM_STR);
                    $result->bindValue(":keywords", $keywords, PDO::PARAM_STR);
                    $result->bindValue(":about", $about, PDO::PARAM_STR);
                    $result->bindValue(":url", $url, PDO::PARAM_STR);
                    $result->execute(); 
                    $errors[] = 'Видео успешно загружено';

                }

            }

            parent::view('admin/import', [
                'title' => 'Import файлов',
                'errors' => $errors,
                'list' => $list,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

}