<?php

class AdminCategory extends Base {

    public static function index() {

        if (parent::admin()) {

            $list = Flight::db()->query("SELECT * FROM `category` ORDER BY pos DESC")->fetchAll();

            parent::view('admin/category_list', [
                'title' => 'Менеджер категорий',
                'list' => $list,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }
    
    public static function down($id) {
        $id = abs((int)$id);
        $result = Flight::db()->prepare("SELECT * FROM `category` WHERE id = :id");
        $result->bindValue(":id", $id, PDO::PARAM_INT);
        $result->execute(); 
        $cat = $result->fetch(PDO::FETCH_ASSOC);
        
        //$cat = Flight::db()->query("SELECT * FROM `category` WHERE `id` = {$id}")->fetch();
        $cat2 = Flight::db()->query("SELECT * FROM `category` WHERE `pos` < '{$cat['pos']}' ORDER BY pos DESC")->fetch();

        $string = sprintf(
                    "UPDATE `category` SET
                    `pos` = '%s'
                    WHERE `id` = %s",
                    $cat2['pos'], $id
                    );
        Flight::db()->query($string);

        $string = sprintf(
                    "UPDATE `category` SET
                    `pos` = '%s'
                    WHERE `id` = %s",
                    $cat['pos'], $cat2['id']
                    );
        Flight::db()->query($string);
        
        Flight::redirect('/admin/category');
    }
    
    public static function up($id) {
        $id = abs((int)$id);
        $result = Flight::db()->prepare("SELECT * FROM `category` WHERE id = :id");
        $result->bindValue(":id", $id, PDO::PARAM_INT);
        $result->execute(); 
        $cat = $result->fetch(PDO::FETCH_ASSOC);
        
        //$cat = Flight::db()->query("SELECT * FROM `category` WHERE `id` = {$id}")->fetch();
        $cat2 = Flight::db()->query("SELECT * FROM `category` WHERE `pos` > '{$cat['pos']}' ORDER BY pos ASC")->fetch();

        $string = sprintf(
                    "UPDATE `category` SET
                    `pos` = '%s'
                    WHERE `id` = %s",
                    $cat2['pos'], $id
                    );
        Flight::db()->query($string);

        $string = sprintf(
                    "UPDATE `category` SET
                    `pos` = '%s'
                    WHERE `id` = %s",
                    $cat['pos'], $cat2['id']
                    );
        Flight::db()->query($string);

        Flight::redirect('/admin/category');
    }

    public static function add() {

        if (parent::admin()) {

            $errors = array();

            if (parent::isMethod('POST')) {

                $name = (parent::data('name')) ? parent::data('name') : '';
                $url = (parent::data('url')) ? parent::data('url') : '';
                $keywords = (parent::data('keywords')) ? parent::data('keywords') : '';
                $description = (parent::data('description')) ? parent::data('description') : '';


                if (empty($name))
                    $errors[] = 'Имя не заполнено';
                if (empty($url))
                    $errors[] = 'URL не заполнен';

                if ( ! $errors) {

                    $string = sprintf(
                        "INSERT INTO `category` SET `name` = '%s', `description` = '%s', `keywords` = '%s', `url` = '%s'",
                        $name, $description, $keywords, $url
                    );

                    Flight::db()->query($string);

                    $errors[] = 'Категория успешно добавлена';

                }

            }

            parent::view('admin/category_add', [
                'title' => 'Добавить категорию',
                'errors' => $errors,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

    public static function edit($id) {
        
        $id = abs((int)$id);
        if (parent::admin()) {

            $errors = array();

            $cat = $list = Flight::db()->query("SELECT * FROM `category` WHERE `id` = {$id}")->fetch();

            if (parent::isMethod('POST')) {

                $name = (parent::data('name')) ? parent::data('name') : '';
                $url = (parent::data('url')) ? parent::data('url') : '';
                $keywords = (parent::data('keywords')) ? parent::data('keywords') : '';
                $description = (parent::data('description')) ? parent::data('description') : '';


                if (empty($name))
                    $errors[] = 'Имя не заполнено';
                elseif (empty($url))
                    $errors[] = 'URL не заполнен';

                if ( ! $errors) {

                    $string = sprintf(
                        "UPDATE `category` SET
                        `name` = '%s',
                        `description` = '%s',
                        `keywords` = '%s',
                        `url` = '%s'
                        WHERE `id` = %s",
                        $name, $description, $keywords, $url, $id
                    );

                    Flight::db()->query($string);

                    $errors[] = 'Категория успешно изменена';

                }

            }

            parent::view('admin/category_edit', [
                'title' => 'Изменить категорию',
                'errors' => $errors,
                'cat' => $cat,
                'description' => '',
                'keywords'    => '',
            ]);

        } else Flight::redirect('/admin');

    }

    public static function delete($id) {
        
        $id = abs((int)$id);
        if (parent::admin()) {

            if (parent::isMethod('POST')) {

                Flight::db()->query("DELETE FROM `category` WHERE `id` = {$id}");
                Flight::redirect('/admin/category');

            }

            parent::view('admin/cat_delete');

        } else Flight::redirect('/admin');

    }

}