<?php
$title = 'Поиск';
include_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

echo '<div class="title">Поиск</div>
<div class="menu">
<form action="" method="get">
<input type="text" name="search" value="'.$search.'">
<input type="submit" value="Поиск">
</form></div>';

if ($search) {

    $keywords = preg_replace("/[\s,]+/", "|", $search);

    $stmt_num = $connect->prepare("select count(*) from `link` where `url` rlike :keywords or `name` rlike :keywords or `text` rlike :keywords");
    $stmt_num->bindValue(':keywords', $keywords);
    $stmt_num->execute();
    $count_res = $stmt_num->fetchColumn();

    if ($count_res == 0) {
        echo '<div class="menu">Ничего не найдено!</div>';
    } else {

        echo '<div class="menu">Найдено по запросу: '.$count_res.'</div>';

        $page = new Pagination($count_res, 10);
        $page->setLink('?search=' . $search . '&');

        $data = $connect->prepare("select * from `link` where `url` rlike :keywords or `name` rlike :keywords or `text` rlike :keywords order by `id` desc limit :start, 10");
        $data->bindValue(':keywords', $keywords);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {
            echo '<div class="menu"><a href="/link/'.$row['id'].'">'.$row['name'].'</a><br/>'.$row['text'].'</div>';
        }

        $page->navigation();

    }
}

include_once($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>