<?php
$title = 'Добавление сайта';
include_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
echo '<div class="title">Добавление сайта</div>';
if ($count_kat == 0) {
    echo '<div class="menu">Категорий нет!</div>';
} else {
    if (isset($_POST['submit'])) {

        $stmt_num = $connect->prepare("select count(*) from `link` where `url` = ?");
        $stmt_num->execute(array($_POST['url']));
        $num = $stmt_num->fetchColumn();

        $error = '';
        if (empty($_POST['code'])) {
            $error.= 'Введите код с картинки!<br/>';
        }
        elseif ($_SESSION['code'] != $_POST['code'] or !is_numeric($_POST['code'])) {
            $error.= 'Код с картинки введен неверно!<br/>';
        } else {
            if (empty($_POST['kat'])) {
                $error.= 'Выберите категорию!<br/>';
            }
            if (empty($_POST['url'])) {
                $error.= 'Введите URL!<br/>';
            }
            elseif (!isSiteAvailable($_POST['url']) || preg_match("#^https?://(.*?)/(.*?)?$#i", $_POST['url'])) {
                $error.= 'URL недоступен или введен не правильно!<br/>';
            }
            elseif (mb_strlen($_POST['url']) < 5 or mb_strlen($_POST['url']) > 75) {
                $error.= 'URL-адрес должен содержать не менее 5 и не более 75 символов!<br/>';
            }
            elseif ($num > 0) {
                $error.= 'Сайт с таким URL уже есть в каталоге!<br/>';
            }
            if (empty($_POST['name'])) {
                $error.= 'Введите название!<br/>';
            }
            elseif (mb_strlen($_POST['name']) < 5 or mb_strlen($_POST['name']) > 75) {
                $error.= 'Название должно содержать не менее 5 и не более 75 символов!<br/>';
            }
            if (empty($_POST['text'])) {
                $error.= 'Введите описание!<br/>';
            }
            elseif (mb_strlen($_POST['text']) < 50 or mb_strlen($_POST['text']) > 2500) {
                $error.= 'Описание должно содержать не менее 50 и не более 2500 символов!<br/>';
            }
        }
        if (!empty($error)) {
            echo '<div class="menu">'.$error.'</div>';
        } else {
            $stmt = $connect->prepare("insert into `link` set `time` = ?, `url` = ?, `name` = ?, `text` = ?, `kat` = ?");
            if ($stmt->execute(array(time(), $_POST['url'], $_POST['name'], $_POST['text'], $_POST['kat']))) {
                echo '<div class="menu"><div class="good">Сайт успешно добавлен в каталог и отправлен на модерацию!</div></div>';
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }
    echo '<div class="menu">
    <form action="" method="post">
    URL-адрес:<br/><input type="text" name="url" value="http://"><br/>
    Название:<br/><input type="text" name="name"><br/>
    Описание:<br/><textarea name="text"></textarea><br/>
    Категория:<br/><select name="kat">';

    $sql = $connect->query("select * from `kat` order by `id` desc")->fetchAll();
    foreach ($sql as $row)
        echo '<option value="'.$row['id'].'">'.$row['name'].'</option>';

    echo '</select><br/>
    Код с картинки:<img id="captcha" src="/img/code.php" alt="check" onClick="UpCaptcha()"><br />
    <input type="text" name="code" /><br/>
    <input type="submit" name="submit" value="Продолжить">
    </form></div>';
}
include_once($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>