/* Функции */

// Вставка текста
function AddTXT(selector, bb) {
    $(document).ready(function() {
        var text = $(selector).val();
        $(selector).val(text+bb);
    });
}
// Ajax
function AjaxRequest(selector, url, data, type, before) {
    $.ajax({
        url: url,
        data: data,
        type: type,
        beforeSend: function() {
            if (before != undefined)
                $(selector).html(before);
        },
        success: function(data) {
            $(selector).html(data);
        }
    });
}
// Обновление капчи
function UpCaptcha() {
    $('#captcha').attr('src', '/img/code.php?' + Math.random() );
}
// Прячем элемент при нажатии на любую область, кроме самого элемента
function mouseupHide(selector) {
    $(document).mouseup(function (e){ // событие клика по веб-документу
        if ($(selector).css('display') != 'none') {
            if (!$(selector).is(e.target) // если клик был не по нашему блоку
                && $(selector).has(e.target).length === 0) { // и не по его дочерним элементам
                    $(selector).fadeOut(500); // скрываем его
            }
       }
    });
}
// Выравнивание элементов по одной ширине (2-6)
function navLinkWidth(selector, find) {
    var navLink = $(selector).find(find);
    switch (navLink.length) {
        case 6:
            navLink.css({'min-width' : '16%', 'max-width' : '17%'});
            break;
        case 5:
            navLink.css('width', '20%');
            break;
        case 4:
            navLink.css('width', '25%');
            break;
        case 3:
            navLink.css({'min-width' : '33%', 'max-width' : '34%'});
            break;
        case 2:
            navLink.css('width', '50%');
            break;
    }
}

/* Во время выполнения */

$(function() {

    // Для .nav-link
    navLinkWidth('.nav-link', 'a');

    // Для .nav-foot
    navLinkWidth('.nav-foot', 'a');

    // Для всех .drop-menu
    $('.drop-menu').each(function(index, element) {
        mouseupHide('#' + $(element).attr('id'));
    });

    // Для всех ссылок, открывающих .drop-menu
    $('[drop-menu]').each(function(index, element) {
        $(element).click(function() {
            if ($('#' + $(element).attr('drop-menu')).css('display') == 'none') {
                $('#' + $(element).attr('drop-menu')).fadeIn(500);
            }
        });
    });

});