<?php

/*
 * Парсер SQL-запросов
 */

class SQLParser {

    /*
     * Выборка SQL-запросов из файла
     * @param string $file
     * @return array
     */

    public static function getQueriesFromFile($file) {

        $sql = file_get_contents($file);

        return self::getQueries($sql);

    }

    /*
     * Разбор SQL-строки на запросы
     * @param string $sql
     * @return array
     */

    public static function getQueries($sql) {

        $sql = trim($sql);

        $buffer = [];

        $query = [];

        $in_string = false;

        $strlen = strlen($sql);

        for ($i = 0; $i < $strlen - 1; $i++) {

            if ($sql[$i] == ";" && !$in_string) {

                $query[] = substr($sql, 0, $i);
                $sql = substr($sql, $i + 1);
                $i = 0;

            }

            if ($in_string && ($sql[$i] == $in_string) && $buffer[1] != "\\") {

                $in_string = false;

            } elseif (!$in_string && ($sql[$i] == '"' || $sql[$i] == "'") && (!isset($buffer[0]) || $buffer[0] != "\\")) {

                $in_string = $sql[$i];

            }

            if (isset($buffer[1])) {

                $buffer[0] = $buffer[1];

            }

            $buffer[1] = $sql[$i];

        }

        if (!empty($sql)) {

            $query[] = $sql;

        }

        return $query;

    }

}

 ?>