<?php
// Ссылки
function bblinks($link) {

    $link = preg_replace_callback(

        '~\\[url=(https?://.+?)\\](.+?)\\[/url\\]|(https?://[0-9a-zA-Z\.\-]+\.[0-9a-zA-Z]{2,6}[0-9a-zA-Z/\?\.\-\~&;_=%:#\+]*)~',

        function ($m) {

            if (isset($m[3])) {

                $url = '<a href="' . $m[3] . '">' . $m[3] . '</a>';

            } else {

                $url = '<a href="' . $m[1] . '">' . $m[2] . '</a>';

            }

            return $url;

        },

        $link

    );

    return $link;

}
// Очистка всех кукисов
function cookie_destroy($dir = null) {
    foreach ($_COOKIE as $key => $value) {
        setcookie($key, null, time() - 3600, $dir);
    }
}
// ТИЦ
function cy($url) {
    $str = file("http://bar-navig.yandex.ru/u?ver=2&show=32&url=".$url);
    if ($str) {
        $is_find = preg_match("/value=\"(.\d*)\"/", join("", $str), $tic);
        if ($is_find < 1) {
            $ans = 0;
        } else {
            $ans = $tic[1];
        }
    }
    return $ans ?? 0;
}
// Rang
function rang($url) {
    $str = file("http://bar-navig.yandex.ru/u?ver=2&show=32&url=".$url);
    if ($str) {
        $is_find = preg_match("/rang=\"(.\d*)\"/", join("", $str), $rang);
        if ($is_find < 1) {
            $ans = 0;
        } else {
            $ans = $rang[1];
        }
    }
    return $ans ?? 0;
}
// Поиск тегов
function tagSearch($str) {

    $tags = preg_split('/[\s,]+/', $str);

    return $tags;

}
// Вывод тегов
function taglink($str, $href) {

    $res = NULL;

    $explode = tagSearch($str);

    foreach ($explode as $tag) {

        $res .= '<a href="' . $href . urlencode($tag) . '">' . $tag . '</a>, ';

    }

    $res = trim($res, ', ');

    return $res;

}
// Валидность URL
function isSiteAvailable($url) {

    if (filter_var($url, FILTER_VALIDATE_URL)) {

        $init = curl_init($url);
        curl_setopt($init, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($init, CURLOPT_HEADER, true);
        curl_setopt($init, CURLOPT_NOBODY, true);
        curl_setopt($init, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($init);
        curl_close($init);

        return $response;

    } else
        return false;

}
// Функция отправки почты на email
function mailto($mail, $theme, $text, $str) {

    $adt = 'From: ' . $str . PHP_EOL;
    $adt .= 'X-sender: < ' . $str . ' >' . PHP_EOL;
    $adt .= 'Content-Type: text/html; charset=utf-8' . PHP_EOL;

    return mail($mail, $theme, $text, $adt);

}
// Транслит
function rus2translit($str) {

    $rus = ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К',
                 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц',
                 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я', 'а', 'б', 'в',
                 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н',
                 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ',
                 'ъ', 'ы', 'ь', 'э', 'ю', 'я'];

    $lat = ['A', 'B', 'V', 'G', 'D', 'E', 'E', 'Gh', 'Z', 'I', 'Y', 'K',
                'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'H', 'C',
                'Ch', 'Sh', 'Sch', 'Y', 'Y', 'Y', 'E', 'Yu', 'Ya', 'a', 'b', 'v',
                'g', 'd', 'e', 'e', 'gh', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o',
                'p', 'r', 's', 't', 'u', 'f', 'h', 'c', 'ch', 'sh', 'sch',
                'y', 'y', 'y', 'e', 'yu', 'ya'];

    $str = str_replace($rus, $lat, $str);

    return $str;

}
// Валидация url
function str2url($str) {

    // переводим в транслит
    $str = rus2translit($str);

    // заменям все ненужное нам на тире
    $str = preg_replace('~[^-a-zA-Z0-9_]+~u', '-', $str);

    // удаляем начальные и конечные тире
    $str = trim($str, '-');

    return $str;

}
// Генератор пароля
function gen_pass($col = 6) {

    $mask = "0123456789AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";

    $password = NULL;

    for ($i = 0; $i < $col; $i++) {

        $password.= $mask[random_int(0, 61)];

    }

    return $password;

}
 ?>