<?php
// Настройки сайта
$fileconfig = __DIR__."/system.ini";
$system = parse_ini_file($fileconfig, true);
// Подключение к БД
try {
    $connect = new PDO('mysql:host=' . $system['db']['db_host'] . ';dbname=' . $system['db']['db_name'] . ';charset=utf8', $system['db']['db_user'], $system['db']['db_pass']);
} catch (PDOException $e) {
    exit('Подключение не удалось: ' . $e->getMessage());
}
// Функции для работы с файлами
include_once(__DIR__."/file_function.php");
// Фильтр данных
include_once(__DIR__."/data_filter.php");
// Постраничная навигация
include_once(__DIR__."/Pagination.php");
// Обработка времени
require_once(__DIR__."/daytime.php");
// Tools
require_once(__DIR__."/tools.php");
// IP посетителя
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
// Определение реального браузера
$ua = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
// Кодировка
mb_internal_encoding('UTF-8');
// Корневая папка
define('ROOT', 'http://'.$_SERVER['HTTP_HOST']);
// Все символы (REGEXP SQL)
define('RS_ALL_CHARS', '.*');
// Дата и время
date_default_timezone_set('Europe/Moscow');
// Админка
if (isset($_COOKIE['pass']) && $_COOKIE['pass'] == $system['system']['pass'])
    $admin = 1;
// Новый сайт в каталоге
$link_desc = $connect->query("select * from `link` where `off` = '0' order by `id` desc limit 1")->fetch(PDO::FETCH_LAZY);
// Кол-во новостей
$count_news = $connect->query("select  count(*) from `news`")->fetchColumn();
// Кол-во категорий
$count_kat = $connect->query("select count(*) from `kat`")->fetchColumn();
// Кол-во сайтов
$count_link = $connect->query("select count(*) from `link`")->fetchColumn();
// Рекомендации
$count_best_link = $connect->query("select count(*) from `link` where `off` = '0' and `star` = '1'")->fetchColumn();
// Кол-во активных сайтов
$count_active_link = $connect->query("select count(*) from `link` where `off` = '0'")->fetchColumn();
// Кол-во неактивных сайтов
$count_mod_link = $connect->query("select count(*) from `link` where `off` = '1'")->fetchColumn();
$new_mod = $count_mod_link > 0 ? '<font color="#d8544f">+'.$count_mod_link.'</font>' : '';
?>