<?php
// Пишем в ini файл
function write_ini_file($filename, $config) {

    if (is_readable($filename)) {

        $res = NULL;

        foreach ($config as $section => $values) {

            $res .= '[' . $section . ']' . PHP_EOL;

            foreach ($values as $key => $value) {

                $res .= $key . ' = ' . (is_numeric($value) ? $value : '"' . $value . '"') . PHP_EOL;

            }

            $res .= PHP_EOL;

        }

        return file_put_contents($filename, $res);

    } else
        return false;

}
// Изменяем структуру массива $_FILES
function reArrayFiles($file_post) {

    $file_array = [];
    $file_count = count($file_post['name']);
    $file_keys = array_keys($file_post);

    for ($i = 0; $i < $file_count; $i++) {

        foreach ($file_keys as $key) {

            $file_array[$i][$key] = $file_post[$key][$i];

        }

    }

    return $file_array;

}
// Расширение файла
function get_extfile($filename) {

    $info = new SplFileInfo($filename);
    $ext = $info->getExtension();

    return strtolower($ext);

}
// Загрузка файла
function file_force_download($file, $prefix = null, $hide = 0) {

    if (is_readable($file)) {

        // Чистим буфер
        ob_get_level() and ob_end_clean();

        // Имя файла
        $name = trim($prefix) . ($hide == 1 ? random_int(11111, 99999) . '_file.' . get_extfile($file) : basename($file));

        // Выдаем файл
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$name);
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: '.filesize($file));

        return readfile($file);

    } else
        return false;

}
// Вес файла
function get_filesize($file) {

    if (!file_exists($file)) {

        return 'Файл не найден';

    } else {

        $filesize = filesize($file);

        if ($filesize > 1024) {

            $filesize = $filesize / 1024;

            if ($filesize > 1024) {

                $filesize = $filesize / 1024;

                if ($filesize > 1024) {

                    $filesize = round($filesize / 1024, 1);

                    return $filesize . ' Gb';

                } else {

                    $filesize = round($filesize, 1);

                    return $filesize . ' Mb';

                }

            } else {

                $filesize = round($filesize, 1);

                return $filesize . ' Kb';

            }

        } else {

            $filesize = round($filesize, 1);

            return $filesize . ' b';

        }

    }

}
// Удаление файлов из папки
function delete_files_dir($dir) {

    if (is_dir($dir)) {

        $scan = scandir($dir);

        foreach ($scan as $file) {

            $filename = "$dir/$file";

            if (is_file($filename)) {

                unlink($filename);

            }

        }

    }

}
// Рекурсивное удаление папки
function delete_dir($dir) {

    if (is_dir($dir)) {

        $scan = scandir($dir);

        foreach ($scan as $file) {

            $filename = "$dir/$file";

            if ($file != "." && $file != "..") {

                if (is_dir($filename)) {

                    delete_dir($filename);

                } else {

                    unlink($filename);

                }

            }

        }

        return rmdir($dir);

    } else
        return false;

}
 ?>