<?php

/*
 * Белый каталог сайтов
 * Author - rekmixa
 * E-mail - rekmixa@gmail.com
 * Site - http://wordads.ru
 */

require($_SERVER["DOCUMENT_ROOT"]."/inc/checker.php");

ob_start();

/* Установка */

session_name('SID') . session_start();

require_once($_SERVER["DOCUMENT_ROOT"]."/inc/file_function.php");
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/data_filter.php");
require_once("SQLParser.php");

?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<link rel="shortcut icon" href="/favicon.ico"/>
<link rel="stylesheet" href="/style/bootstrap/css/bootstrap.min.css" type="text/css"/> 
<link rel="stylesheet" href="/style/default.css" type="text/css"/>
<title>Установка</title>
<script type="text/javascript" src="/js/jquery.js"></script>
<script type="text/javascript" src="/style/bootstrap/js/bootstrap.min.js"></script>
<script type="text/javascript" src="/js/function.js"></script> 
</head>
<body>
<div class="logo"><img src="/img/logo.png" alt="logo"></div>
<?

// Системный файл настроек
$fileconfig = $_SERVER["DOCUMENT_ROOT"]."/inc/system.ini";
$system = parse_ini_file($fileconfig, true);

$step = $_GET['step'] ?? false;

switch ($step) {

    case 'complete':

        if (isset($_SESSION['complete_install'])) {

            // Удаляем папку install
            delete_dir(__DIR__);

            header('Location: /');

        } else {

            // Возвращаем к началу
            header('Location: /install');

        }

        break;

    case 'pass':

        echo '<div class="title">Панель управления</div>';

        if (isset($_POST['install'])) {

            $error = '';

            if (empty($_POST['adm'])) {
                $error.= 'Придумайте пароль!<br/>';
            }
            elseif (!preg_match("#^[a-z0-9_-]{1,15}$#i", $_POST['adm'])) {
                $error.= 'Пароль должен состоять из латинских букв и/или цифр!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                /* Настройки */

                $system['system']['pass'] = $_POST['adm'];

                setcookie('pass', $_POST['adm'], time() + 3600 * 24 * 365, '/');

                write_ini_file($fileconfig, $system);

                $_SESSION['complete_install'] = 1; // разрешаем завершить установку
 
                echo '<div class="menu">
                <ul class="tick">
                <li>Пароль для панели управления установлен!</li>
                </ul>
                <div class="butt5"><a href="?step=complete">Завершить установку</div></div>
                </div>';

            }

        }

        echo '<div class="menu">
        <form method="POST">
        Придумайте пароль для админки:<br/><input type="text" name="adm" /><br/>
        <input type="submit" name="install" value="Продолжить установку">
        </form></div>';

        break;

    case 'db':

        echo '<div class="title">Подключение к БД</div>';

        if (isset($_POST['install'])) {

            $error = '';

            if (empty($_POST['host']) || empty($_POST['base']) || empty($_POST['user']) || empty($_POST['password'])) {
                $error.= 'Вы не заполнили одно из полей!<br/>';
            } else {
                try {
                    $connect = new PDO('mysql:host=' . $_POST['host'] . ';dbname=' . $_POST['base'], $_POST['user'], $_POST['password']);
                } catch (PDOException $e) {
                    $error.= 'Подключение не удалось: ' . $e . '<br/>';
                }
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                /* Заливка таблиц */

                $connect->exec("SET CHARACTER SET utf8");

                $tables = SQLParser::getQueriesFromFile("tables.sql");

                foreach ($tables as $sql) {

                    $connect->exec($sql);

                }

                // CHMOD
                chmod($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php", 0666);
                chmod($fileconfig, 0666);

                /* Настройки */

                $system['db']['db_host'] = $_POST['host'];
                $system['db']['db_user'] = $_POST['user'];
                $system['db']['db_pass'] = $_POST['password'];
                $system['db']['db_name'] = $_POST['base'];

                write_ini_file($fileconfig, $system);

                echo '<div class="menu">
                <ul class="tick">
                <li>Соединение с БД установлено!</li>
                <li>Таблицы успешно залиты!</li>
                <li>Права на файлы конфигурации установлены!</li>
                </ul>
                <div class="butt5"><a href="?step=pass">Следующий шаг</div></div>
                </div>';

            }

        }

        echo '<div class="menu">
        <form method="POST">
        Хост:<br/><input type="text" name="host" value="localhost" /><br/>
        Пользователь:<br/><input type="text" name="user"><br/>
        Пароль:<br/><input type="text" name="password"><br/>
        База данных:<br/><input type="text" name="base"><br/>
        <input type="submit" name="install" value="Продолжить установку">
        </form></div>';

        break;

    default:

        echo '<div class="title">Подготовка к установке</div>
        <div class="menu">
        <div class="good">Скрипт готов к установке!</div>
        <div class="butt5"><a href="?step=db">Начать установку</a></div>
        </div>';

}

?>
<div class="ze"><?=date('H:i:s');?></div>
</body>
</html>
<? ob_end_flush(); ?>