<?php
// Временные зоны по смещению (-11;+14)
define('TIMEZONES', [
   'GMT-11:00' => 'Pacific/Pago_Pago',
   'GMT-10:00' => 'Pacific/Tahiti',
   'GMT-09:30' => 'Pacific/Marquesas',
   'GMT-09:00' => 'Pacific/Gambier',
   'GMT-08:00' => 'America/Los_Angeles',
   'GMT-07:00' => 'America/Yellowknife',
   'GMT-06:00' => 'America/Chicago',
   'GMT-05:00' => 'Pacific/Easter',
   'GMT-04:00' => 'Atlantic/Bermuda',
   'GMT-03:30' => 'America/St_Johns',
   'GMT-03:00' => 'Atlantic/Stanley',
   'GMT-02:00' => 'Atlantic/South_Georgia',
   'GMT-01:00' => 'Atlantic/Cape_Verde',
   'GMT+00:00' => 'UTC',
   'GMT+01:00' => 'Europe/Zurich',
   'GMT+02:00' => 'Europe/Zaporozhye',
   'GMT+03:00' => 'Europe/Moscow',
   'GMT+03:30' => 'Asia/Tehran',
   'GMT+04:00' => 'Asia/Dubai',
   'GMT+04:30' => 'Asia/Kabul',
   'GMT+05:00' => 'Asia/Yekaterinburg',
   'GMT+05:30' => 'Asia/Kolkata',
   'GMT+05:45' => 'Asia/Kathmandu',
   'GMT+06:00' => 'Asia/Omsk',
   'GMT+06:30' => 'Indian/Cocos',
   'GMT+07:00' => 'Asia/Novosibirsk',
   'GMT+08:00' => 'Australia/Perth',
   'GMT+08:30' => 'Asia/Pyongyang',
   'GMT+08:45' => 'Australia/Eucla',
   'GMT+09:00' => 'Asia/Tokyo',
   'GMT+09:30' => 'Australia/Darwin',
   'GMT+10:00' => 'Australia/Brisbane',
   'GMT+10:30' => 'Australia/Broken_Hill',
   'GMT+11:00' => 'Australia/Sydney',
   'GMT+12:00' => 'Pacific/Wallis',
   'GMT+13:00' => 'Pacific/Fiji',
   'GMT+13:45' => 'Pacific/Chatham',
   'GMT+14:00' => 'Pacific/Tongatapu'
]);
// Валидация даты
function validateDate($date, $format = 'Y-m-d H:i:s') {

    $d = DateTime::createFromFormat($format, $date);

    return ($d && $d->format($format) == $date);

}
// Проверка Timezone ID
function isAvailableTimezone($timezone) {

    try {

        $date = new DateTimeZone($timezone);

        return true;

    } catch (Exception $e) {

        return false;

    }

}
// Аналог mktime() только с установлением временной зоны
function getTimeByTimezone($timezone, $hour = 0, $minut = 0, $second = 0) {

    // Объект класса DateTime
    $date = new DateTime;

    // Устанавливаем временную зону
    $date->setTimezone(new DateTimeZone($timezone));

    // Задаем время
    $date->setTime($hour, $minut, $second);

    // Возвращаем метку времени Unix
    return $date->getTimestamp();

}
// Склонение количеств
function quantDec($num, $word) {

    $col = intval($num);
    $rest = substr($col, -1);

    if ($col > 10 && $col < 20) {

        $res = trim($word[2]);

    } elseif ($rest > 1 && $rest < 5) {

        $res = trim($word[1]);

    } elseif ($rest == 1) {

        $res = trim($word[0]);

    } else {

        $res = trim($word[2]);

    }

    return "$num $res";

}
// Остаток времени
function restime($sec) {

    $sec = intval($sec);

    $rest = 0;
    $year = 3600 * 24 * 365;
    $month = 3600 * 24 * 30;
    $day = 3600 * 24;
    $hour = 3600;
    $min = 60;

    if ($sec >= $year) {

        $col = $sec / $year;
        $full_time = quantDec(intval($col), ['год', 'года', 'лет']);
        $rest += $sec % $year;

    } elseif ($sec >= $month) {

        $col = $sec / $month;
        $full_time = quantDec(intval($col), ['месяц', 'месяца', 'месяцев']);
        $rest += $sec % $month;

    } elseif ($sec >= $day) {

        $col = $sec / $day;
        $full_time = quantDec(intval($col), ['день', 'дня', 'дней']);
        $rest += $sec % $day;

    } elseif ($sec >= $hour) {

        $col = $sec / $hour;
        $full_time = quantDec(intval($col), ['час', 'часа', 'часов']);
        $rest += $sec % $hour;

    } elseif ($sec >= $min) {

        $col = $sec / $min;
        $full_time = quantDec(intval($col), ['минута', 'минуты', 'минут']);
        $rest += $sec % $min;

    } else {

        $full_time = quantDec($sec, ['секунда', 'секунды', 'секунд']);

    }

    $rest = $rest > 0 ? ', ' . restime($rest) : NULL;
    $full_time.= $rest;

    return $full_time;

}
// Обработка времени
function daytime($var) {

    $date = date('d.m.Y', $var);
    $time = date('H:i', $var);
    $hour = date('H', $var);
    $minut = date('i', $var);

    if ($date == date('d.m.Y')) {

        if ($time == date('H:i')) {

            $full_time = 'Только что';

        } elseif ($hour == date('H')) {

            $full_time = quantDec(date('i') - $minut, ['минуту', 'минуты', 'минут']) . ' назад';

        } else {

            $full_time = date('Сегодня в H:i', $var);

        }

    } elseif ($date == date('d.m.Y', time() - 3600 * 24)) {

        $full_time = date('Вчера в H:i', $var);

    } elseif ($date == date('d.m.Y', time() - 3600 * 24 * 2)) {

        $full_time = date('Позавчера в H:i', $var);

    } else {

        $full_time = date('d.m.Y в H:i', $var);

    }

    return $full_time;

}

 ?>