<?php
// Постраничная навигация
class Pagination {

    public $k_post, $post, $k_page, $page, $start;
    private $link = '?';
    private $get = 'page';

    function __construct($k_post, $post) {

        $this->k_post = intval($k_post);
        $this->post = intval($post);

        $this->k_page = $this->k_post != 0 ? ceil($this->k_post / $this->post) : 1;
        $this->page = $this->page();
        $this->start = $this->post * $this->page - $this->post;

    }

    public function setLink($link) {
        $this->link = $link;
    }

    public function setGET($get) {
        $this->get = $get;
    }

    public function page() {

        if (isset($_GET[$this->get])) {

            if ($_GET[$this->get] == 'end') {

                $page = $this->k_page;

            } elseif (is_numeric($_GET[$this->get])) {

                $page = $_GET[$this->get];

            }

            if ($page < 1) {

                $page = 1;

            } else {

                if ($page > $this->k_page) {

                     $page = $this->k_page;

                }

            }

        } else {

            $page = 1;

        }

        return intval($page);

    }

    public function navigation() {

        if ($this->k_page > 1) {

            echo '<div class="menu">
            <div class="page">';

            if ($this->page != 1) {

                echo '<a href="' . $this->link . $this->get . '=1">1</a>';

            } else {

                echo '<span>1</span>';

            }

            for ($i = -3; $i <= 3; $i++) {

                if ($this->page + $i > 1 && $this->page + $i < $this->k_page) {

                    if ($i == -3 && $this->page + $i > 2) {

                        echo '<span>...</span>';

                    }

                    if ($i != 0) {

                        echo '<a href="' . $this->link . $this->get . '=' . ($this->page + $i) . '">' . ($this->page + $i) . '</a>';

                    } else {

                        echo '<span>' . ($this->page + $i) . '</span>';

                    }

                    if ($i == 3 && $this->page + $i < $this->k_page - 1) {

                        echo '<span>...</span>';

                    }

                }

            }

            if ($this->page != $this->k_page) {

                echo '<a href="' . $this->link . $this->get . '=end" class="end">' . $this->k_page . '</a>';

            } elseif ($this->k_page > 1) {

                echo '<span>' . $this->k_page . '</span>';

            }

            echo '</div></div>';

        }

    }

}
 ?>