<?php

/*
 * Скрипт защиты от CSRF
 */

// Имя поля с id сессии
define('CSRF_INPUT_NAME', 'session_id');

/* Проверка сессии */

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (!filter_has_var(INPUT_POST, CSRF_INPUT_NAME) || $_POST[CSRF_INPUT_NAME] != session_id()) {

        // Генерируем новый id сессии
        session_regenerate_id();
        // Удаляем зловредные данные
        unset($_POST);

    }

}

/* Добавляем скрытые поля с id сессии во все формы */

function csrf_inputs($buffer) {

    $doc = new DOMDocument;

    $doc->loadHTML($buffer);

    $forms = $doc->getElementsByTagName('form'); // ищем формы

    foreach ($forms as $element) {

        // Узнаем метод передачи данных с формы
        $method = $element->getAttribute('method');
        $method = strtoupper($method);

        // Работаем только с POST-данными
        if ($method != 'POST')
            continue;

        /* Создаем поле */

        $newElement = $doc->createElement('input');

        $node = $element->appendChild($newElement);

        $node->setAttribute('type', 'hidden');
        $node->setAttribute('name', CSRF_INPUT_NAME);
        $node->setAttribute('value', session_id());

    }

    return $doc->saveHTML();

}

// Буферизация вывода
ob_start('csrf_inputs');

 ?>