<?php
$title = 'Настройки системы';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($adm_id == 1) {

    echo '<div class="title">Настройки системы</div>';

    if (isset($_POST['settings'])) {
 
        $error = '';

        $currency = trim($_POST['currency'], ',');

        if (isset($_FILES['filename']) && file_exists($_FILES['filename']['tmp_name'])) {
            if (!BeforeUpload::AttachIMG($_FILES['filename'])) {
                $error.= 'В качестве логотипа разрешено загружать только файлы с расширением JPG, PNG или GIF!<br/>';
            }
        }
        if (empty($_POST['project'])) {
            $error.= 'Введите название проекта!<br/>';
        }
        if (empty($_POST['mail'])) {
            $error.= 'Введите контактный e-mail!<br/>';
        }
        elseif (!filter_var($_POST['mail'], FILTER_VALIDATE_EMAIL)) {
            $error.= 'Поле e-mail заполнено неверно!<br/>';
        }
        if (empty($currency)) {
            $error.= 'Введите валюту сайта!<br/>';
        }
        elseif (count(explode(',', $currency)) > 1 && count(explode(',', $currency)) != 3) {
            $error.= 'Склонений наименования валюты должно быть 3!<br/>';
        }
        if (empty($_POST['timezone'])) {
            $error.= 'Укажите часовой пояс системы!<br/>';
        }
        elseif (!isAvailableTimezone($_POST['timezone'])) {
            $error.= 'Некорректный часовой пояс!<br/>';
        }
        if (empty($_POST['antiflud'])) {
            $error.= 'Укажите время антифлуда!<br/>';
        }
        if (empty($_POST['hsp'])) {
            $error.= 'Укажите время действительности ссылок для восстановления паролей!<br/>';
        }
        if (empty($_POST['spkey'])) {
            $error.= 'Укажите размер ключа ссылок для восстановления паролей!<br/>';
        }
        if (empty($_POST['authkey'])) {
            $error.= 'Укажите размер ключа авторизации!<br/>';
        }
        if (empty($_POST['err_attempts'])) {
            $error.= 'Укажите количество ошибок, после  которых включать капчу!<br/>';
        }
        if (empty($_POST['captcha_time'])) {
            $error.= 'Укажите время действия капчи!<br/>';
        }
        if (empty($_POST['news_s'])) {
            $error.= 'Укажите количество символов в последней новости!<br/>';
        }
        elseif ($_POST['news_s'] < 25) {
            $error.= 'Количество символов в последней новости должно быть больше 25!<br/>';
        }
        if (empty($_POST['wava'])) {
            $error.= 'Укажите размер аватара!<br/>';
        }
        elseif (!sizeConv($_POST['wava'])) {
            $error.= 'Неверный формат размера аватара: вводить нужно в формате ШИРИНАxВЫСОТА!<br/>';
        }
        if (empty($_POST['wico'])) {
            $error.= 'Укажите размер иконки пользователя!<br/>';
        }
        elseif (!sizeConv($_POST['wico'])) {
            $error.= 'Неверный формат размера иконки пользователя: вводить нужно в формате ШИРИНАxВЫСОТА!<br/>';
        }
        if (empty($_POST['attach_img'])) {
            $error.= 'Укажите размер превью изображений в сообщениях!<br/>';
        }
        elseif (!sizeConv($_POST['attach_img'])) {
            $error.= 'Неверный формат размера превью изображений в сообщениях: вводить нужно в формате ШИРИНАxВЫСОТА!<br/>';
        }
        if (empty($_POST['donat_sum'])) {
            $error.= 'Укажите минимальную сумму доната!<br/>';
        }
        elseif ($_POST['donat_sum'] < 0.01) {
            $error.= 'Минимальная сумма доната не может быть меньше 0.01!<br/>';
        }
        if (empty($_POST['upload_mail'])) {
            $error.= 'Укажите максимальный размер файлов при upload в почте!<br/>';
        }
        if (empty($_POST['upload_chat'])) {
            $error.= 'Укажите максимальный размер файлов при upload в чате!<br/>';
        }
        if (empty($_POST['cash'])) {
            $error.= 'Укажите минимальную сумму для вывода средств!<br/>';
        }
        elseif ($_POST['cash'] < 1) {
            $error.= 'Минимальная сумма для вывода средств не может быть меньше 1!<br/>';
        }
        if (empty($_POST['min'])) {
            $error.= 'Укажите минимальную сумму пополнения баланса!<br/>';
        }
        elseif ($_POST['min'] < 1) {
            $error.= 'Минимальная сумма пополнения баланса не может быть меньше 1!<br/>';
        }
        if (empty($_POST['gradient'])) {
            $error.= 'Введите стоимость градиента ника!<br/>';
        }
        elseif ($_POST['gradient'] < 0.01) {
            $error.= 'Стоимость градиента ника не может быть меньше 0.01!<br/>';
        }
        if (empty($_POST['icon'])) {
            $error.= 'Введите стоимость личной иконки!<br/>';
        }
        elseif ($_POST['icon'] < 0.01) {
            $error.= 'Стоимость личной иконки не может быть меньше 0.01!<br/>';
        }
        if (empty($_POST['rename'])) {
            $error.= 'Введите стоимость смены ника!<br/>';
        }
        elseif ($_POST['rename'] < 0.01) {
            $error.= 'Стоимость смены ника не может быть меньше 0.01!<br/>';
        }
        if (empty($_POST['hl-keyword']) || empty($_POST['hl-comment']) || empty($_POST['hl-string']) || empty($_POST['hl-default']) || empty($_POST['hl-html'])) {
            $error.= 'Укажите настройки BB-кода подсветки синтаксиса!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            // Логотип сайта
            if (isset($_FILES['filename']) && file_exists($_FILES['filename']['tmp_name'])) {

                $path = $_SERVER["DOCUMENT_ROOT"]."/img/";

                $logo = "logo_".random_int(11111, 99999)."_".rus2translit($_FILES['filename']['name']);

                if (move_uploaded_file($_FILES['filename']['tmp_name'], $path . $logo)) {

                    if ($logoSite)
                        unlink($logoSite);

                }

            }

            // Система
            $sys['system']['mail'] = $_POST['mail'];
            $sys['system']['currency'] = $currency;
            $sys['system']['project'] = $_POST['project'];
            $sys['system']['keywords'] = $_POST['keywords'];
            $sys['system']['description'] = $_POST['description'];
            $sys['system']['timezone'] = $_POST['timezone'];
            $sys['system']['wava'] = $_POST['wava'];
            $sys['system']['wico'] = $_POST['wico'];
            $sys['system']['attach_img'] = $_POST['attach_img'];
            $sys['system']['news_s'] = intval(abs($_POST['news_s']));
            $sys['system']['ref_cash'] = intval(abs($_POST['ref_cash']));
            $sys['system']['antiflud'] = ceil(abs($_POST['antiflud']));
            $sys['system']['fludtime'] = intval(abs($_POST['fludtime']));
            $sys['system']['hsp'] = ceil(abs($_POST['hsp']));
            $sys['system']['spkey'] = ceil(abs($_POST['spkey']));
            $sys['system']['authkey'] = ceil(abs($_POST['authkey']));
            $sys['system']['err_attempts'] = ceil(abs($_POST['err_attempts']));
            $sys['system']['captcha_time'] = intval(abs($_POST['captcha_time']));
            $sys['system']['min'] = intval(abs($_POST['min']));
            $sys['system']['kom'] = intval(abs($_POST['kom']));
            $sys['system']['cash'] = floatval(abs($_POST['cash']));
            $sys['system']['gradient'] = floatval(abs($_POST['gradient']));
            $sys['system']['icon'] = floatval(abs($_POST['icon']));
            $sys['system']['rename'] = floatval(abs($_POST['rename']));
            $sys['system']['wmid'] = floatval(abs($_POST['wmid']));
            $sys['system']['hl-keyword'] = $_POST['hl-keyword'];
            $sys['system']['hl-comment'] = $_POST['hl-comment'];
            $sys['system']['hl-string'] = $_POST['hl-string'];
            $sys['system']['hl-default'] = $_POST['hl-default'];
            $sys['system']['hl-html'] = $_POST['hl-html'];
            $sys['system']['upload_mail'] = ceil(abs($_POST['upload_mail']));
            $sys['system']['upload_chat'] = ceil(abs($_POST['upload_chat']));
            $sys['system']['donat_sum'] = floatval(abs($_POST['donat_sum']));
            $sys['modules']['donat_s'] = intval($_POST['donat_s']);

            write_ini_file(FILE_CONFIG, $sys);

            header('Location: /adm/system');

        }

    }

    echo '<div class="menu">
    <form action="" method="POST" enctype="multipart/form-data">
    <div class="menu-title">Основное</div>
    Логотип:'.(!$logoSite ? '<span class="red">Загрузите логотип!</span>' : '').'<br/><input type="file" name="filename"><br/>
    Название проекта:<br/><input type="text" name="project" value="'.$sys['system']['project'].'"><br/>
    Контактный e-mail:<br/><input type="text" name="mail" value="'.$sys['system']['mail'].'"><br/>
    Валюта сайта (склонения):<br/><input type="text" name="currency" value="'.$sys['system']['currency'].'"><br/>
    Часовой пояс системы:<br/>
    <select name="timezone">';

    $date = new DateTime;

    foreach (TIMEZONES as $gmt => $value) {

        $dtz = new DateTimeZone($value);

        $date->setTimezone($dtz);

        echo '<option '.($sys['system']['timezone'] == $value ? 'selected' : '').' value="'.$value.'">'.$gmt.' ('.$value.' | '.$date->format('d.m H:i').')</option>';

    }

    echo '</select><br/>
    Keywords (SEO):<br/><input type="text" name="keywords" value="'.$sys['system']['keywords'].'"><br/>
    Description (SEO):<br/><input type="text" name="description" value="'.$sys['system']['description'].'"><br/>
    Время антифлуда (sec):<br/><input type="text" name="antiflud" value="'.$sys['system']['antiflud'].'"><br/>
    Время молчания после регистрации (в минутах):<br/><input type="text" name="fludtime" value="'.$sys['system']['fludtime'].'"><br/>
    Время действительности ссылок для восстановления паролей (в часах):<br/><input type="text" name="hsp" value="'.$sys['system']['hsp'].'"><br/>
    Размер ключа ссылок для восстановления паролей (в байтах):<br/><input type="text" name="spkey" value="'.$sys['system']['spkey'].'"><br/>
    Символов в последней новости:<br/><input type="text" name="news_s" value="'.$sys['system']['news_s'].'"><br/>
    Размер аватара в профиле:<br/><input type="text" name="wava" value="'.$sys['system']['wava'].'"><br/>
    Размер иконки пользователя:<br/><input type="text" name="wico" value="'.$sys['system']['wico'].'"><br/>
    Размер превью изображений в сообщениях:<br/><input type="text" name="attach_img" value="'.$sys['system']['attach_img'].'"><br/>
    <div class="menu-title">Система донатов</div>
    Сбор донатов:<br/><select name="donat_s"><option value="1">Только для продавцов</option><option ' . ($sys['modules']['donat_s'] == 2 ? 'selected' : '') . ' value="2">Для всех</option><option ' . ($sys['modules']['donat_s'] == 0 ? 'selected' : '') . ' value="0">Откл.</option></select><br/>
    Минимальная сумма доната:<br/><input type="text" name="donat_sum" value="'.$sys['system']['donat_sum'].'"><br/>
    <div class="menu-title">Прикрепление файлов</div>
    Максимальный размер файлов при upload в почте (в байтах):<br/><input type="text" name="upload_mail" value="'.$sys['system']['upload_mail'].'"><br/>
    Максимальный размер файлов при upload в чате (в байтах):<br/><input type="text" name="upload_chat" value="'.$sys['system']['upload_chat'].'"><br/>
    <div class="menu-title">Безопасная авторизация</div>
    Размер ключа авторизации (в байтах):<br/><input type="text" name="authkey" value="'.$sys['system']['authkey'].'"><br/>
    Количество ошибок, после  которых включать капчу:<br/><input type="text" name="err_attempts" value="'.$sys['system']['err_attempts'].'"><br/>
    Время действия капчи (в минутах):<br/><input type="text" name="captcha_time" value="'.$sys['system']['captcha_time'].'"><br/>
    <div class="menu-title">Пополнение/Вывод</div>
    Минимальная сумма для вывода средств:<br/><input type="text" name="cash" value="'.$sys['system']['cash'].'"><br/>
    Комиссия на вывод средств (%):<br/><input type="text" name="kom" value="'.$sys['system']['kom'].'"><br/>
    Реферальный процент:<br/><input type="text" name="ref_cash" value="'.$sys['system']['ref_cash'].'"><br/>
    Минимальная сумма пополнения баланса:<br/><input type="text" name="min" value="'.$sys['system']['min'].'"><br/> 
    <div class="menu-title">Дополнительные услуги</div>
    Стоимость градиента ника:<br/><input type="text" name="gradient" value="'.$sys['system']['gradient'].'"><br/>
    Стоимость личной иконки:<br/><input type="text" name="icon" value="'.$sys['system']['icon'].'"><br/>
    Стоимость смены ника:<br/><input type="text" name="rename" value="'.$sys['system']['rename'].'"><br/>
    Стоимость подтверждения WMID:<br/><input type="text" name="wmid" value="'.$sys['system']['wmid'].'"><br/>
    <div class="menu-title">BB-код: подсветка синтаксиса<img src="/img/bb/php.gif" alt="php"></div>
    Цвет ключевых слов:<br/><input type="text" name="hl-keyword" value="'.$sys['system']['hl-keyword'].'"><br/>
    Цвет комментариев:<br/><input type="text" name="hl-comment" value="'.$sys['system']['hl-comment'].'"><br/>
    Цвет строк:<br/><input type="text" name="hl-string" value="'.$sys['system']['hl-string'].'"><br/>
    Цвет HTML-кода:<br/><input type="text" name="hl-html" value="'.$sys['system']['hl-html'].'"><br/>
    Цвет остальных элементов кода:<br/><input type="text" name="hl-default" value="'.$sys['system']['hl-default'].'"><br/>
    <input type="submit" name="settings" value="Сохранить">
    </form></div>';

} else {
    header('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>