<?php
/***********************************
#
	Простой нативный шаблонизатор
			by Kemel
#
***********************************/
final class Template {
	public static $_path = string;
	public static $_template = string;
	public static $_vars = array();

/*
	Выбираем папку с шаблонами
*/
	public static function set_dir() {
		$dir = ROOTPATH.'templates/default/'.strtolower(CONTROLLER_NAME).'/';
		if (is_dir($dir)) self::$_path = $dir;
	}
/*
	Устанавливаем переменные
*/
	static public function set($name, $value) {
		if (is_array($name) and is_array($value)) {
			for ($i=0; $i <= count($name); $i++) self::$_vars[$name[$i]] = $value[$i];
		} else self::$_vars[$name] = $value;
	}

/*
	Получаем переменные
*/
	public function __get($name) {
		if (isset($this->_vars[$name])) return $this->_vars[$name];
		return '';
	}

/*
	Функция вывода шаблона на экран
*/	
	public static function display($template, $header = TRUE) {
		self::set_dir();
		self::$_template = self::$_path . $template;
		if (!file_exists(self::$_template)) die('Шаблона ' . $template . ' не существует!');
		if (count(self::$_vars) > 0) extract(self::$_vars,EXTR_OVERWRITE);	//Извлекаем переменные

		ob_start();
		if ($header) include(ROOTPATH.'templates/default/header.html');
		include(self::$_template);
		if ($header) include(ROOTPATH.'templates/default/footer.html');
		echo ob_get_clean();
		//($_strip == true) ? self::$strip(ob_get_clean()) : ob_get_clean();
	}

/*
	Убираем теги
*/
	static function strip($data) {
		$lit = array("\\t", "\\n", "\\n\\r", "\\r\\n", "  ");
		$sp = array('', '', '', '', '');
		return str_replace($lit, $sp, $data);
	}

/*
	Фильтруем данные от XSS
*/
	public function xss($data) {
		if (is_array($data)) {
			$escaped = array();
			foreach ($data as $key => $value) {
				$escaped[$key] = $this->xss($value);
			}
			return $escaped;
		}
		return htmlspecialchars($data, ENT_QUOTES);
	}
}
?>