<?php
/*******************************
#
	Маршрутизация запросов
			by Kemel
#
*******************************/
final class Route {
	private $controller_name = 'Main';	//контроллер по умолчанию
	private $action_name = 'index';	//действие по умолчанию
	
	
// Без статики	
	public function start() {
		
		$r = htmlentities(trim($_SERVER['REQUEST_URI']));
		$routes = explode('/', $r);

		// получаем имя контроллера
		if ( !empty($routes[1]) ) {
			$this -> controller_name = $routes[1];
		}
		
		// получаем имя экшена
		if ( !empty($routes[2]) ) {
			$this -> action_name = $routes[2];
		}
		if (is_numeric($routes[1]) and !isset($routes[2])) {	//Ебана роут, через rewrite rule не выходит
			$this -> controller_name = 'Main';
			$this -> action_name = 'view';
			$_SERVER['REQUEST_URI'] = '/main/view/'.$routes[1];
		}
		//exit($_SERVER['REQUEST_URI']);

		// добавляем префиксы
		$c = $this -> controller_name;
		$this -> controller_name = 'Controller_'.$this -> controller_name;
		$this -> action_name = 'action_'.$this -> action_name;

		// подцепляем файл с классом контроллера
		$controller_file = strtolower($this -> controller_name).'.php';
		$controller_path = "system/modules/".$controller_file;
		if(file_exists($controller_path)) {
			include "system/modules/".$controller_file;
			define ('CONTROLLER_NAME',$c);
		} else {
			/*
			Контроллер ошибки
			*/
			include "system/modules/".strtolower(CONTROLLER_ERROR).".php";
			define ('CONTROLLER_NAME','Error');
			$this -> controller_name = CONTROLLER_ERROR;
		}
		
		// создаем контроллер
		$controller = new $this -> controller_name;
		$action = $this -> action_name;
		Template::set('site_title',SITE_TITLE);	//Название модуля в шапку
		
		if(method_exists($controller, $action)) {
			// вызываем действие контроллера
			$controller->$action();
		} elseif (method_exists($controller,'action_index')) {
			$controller -> action_index();
		} else {
			Route::ErrorPage();
		}
	
	}
	

	public function ErrorPage() {
		$host = 'http://'.$_SERVER['HTTP_HOST'].'/';
		header('Location:'.$host.'error/');
		exit;
		
        /*
		$host = 'http://'.$_SERVER['HTTP_HOST'].'/';
        header('HTTP/1.1 404 Not Found');
		header("Status: 404 Not Found");
		header('Location:'.$host.'404');
		*/
    }
}
?>