<?php
/**********************************
#
	Класс нужных функций
			by Kemel @2014
#
**********************************/
class Core {

//Функция создания произвольного имени
static function name_rnd($n = 10) {
	$w = array('A','a','B','b','C','c','D','d','F','f','G','g','E','e','J','j','I','i','H','h','K','k','L','l','M','m','N','n','O','o','P','R','r','S','s',
	'T','t','V','v','U','u','Y','y','W','w','Z','z','0','1','2','3','4','5','6','7','8','9');
	$text = '';
	for ($i = 0; $i < $n; $i++) {
		$k = mt_rand(0,count($w));
		$text .= $w[$k];
	}
	return $text;
}

//Функция определения IP
static function getip() {
 if( $_SERVER['HTTP_X_FORWARDED_FOR'] != '' ) {
      $client_ip =( !empty($_SERVER['REMOTE_ADDR']) ) ? $_SERVER['REMOTE_ADDR'] : ( ( !empty($_ENV['REMOTE_ADDR']) ) ? $_ENV['REMOTE_ADDR'] : "unknown" );
      $entries = explode('[, ]', $_SERVER['HTTP_X_FORWARDED_FOR']);
      reset($entries);
      while (list(, $entry) = each($entries)) {
         $entry = trim($entry);
         if ( preg_match("/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/", $entry, $ip_list) ) {
            $private_ip = array(
                  '/^0\./',
                  '/^127\.0\.0\.1/',
                  '/^192\.168\..*/',
                  '/^172\.((1[6-9])|(2[0-9])|(3[0-1]))\..*/',
                  '/^10\..*/');
            $found_ip = preg_replace($private_ip, $client_ip, $ip_list[1]);
            if ($client_ip != $found_ip) {
               $client_ip = $found_ip;
               break;
            }
         }
      }
   }  else {
      $client_ip = (!empty($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : ((!empty($_ENV['REMOTE_ADDR'])) ? $_ENV['REMOTE_ADDR'] : "unknown" );
   }
   if (!filter_var($client_ip, FILTER_VALIDATE_IP)) $client_ip = 'unknown';; 
	return $client_ip;
}

//Функция определения браузера
static function get_user_agent() {
	return $_SERVER['HTTP_USER_AGENT'];
}

//Функция округления размера файла
static function get_filesize($size) {
   // Если размер больше 1 Кб
   if($size > 1024) {
       $size = ($size/1024);
       // Если размер файла больше Килобайта
       // то лучше отобразить его в Мегабайтах. Пересчитываем в Мб
       if($size > 1024) {
            $size = ($size/1024);
           // А уж если файл больше 1 Мегабайта, то проверяем
           // Не больше ли он 1 Гигабайта
           if($size > 1024) {
               $size = ($size/1024);
               $size = round($size, 1);
               return $size." ГБ";       
           } else {
               $size = round($size, 1);
               return $size." MБ";   
           }       
       } else {
           $size = round($size, 1);
           return $size." Кб";   
       }  
   } else {
       $size = round($size, 1);
       return $size." байт";   
   }
}
//Функция скачивание файла
static function file_force_download($file,$name = NULL, $mime = 'application/octet-stream') {
  if (file_exists($file)) {
    // сбрасываем буфер вывода PHP, чтобы избежать переполнения памяти выделенной под скрипт
    // если этого не сделать файл будет читаться в память полностью!
    if (ob_get_level()) {
      ob_end_clean();
    }
    // заставляем браузер показать окно сохранения файла
    header('Content-Description: File Transfer');
    header('Content-Type: '.$mime);
    header('Content-Disposition: attachment; filename=' . (!empty($name) ? $name : basename($file)));
    header('Content-Transfer-Encoding: binary');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($file));
    // читаем файл и отправляем его пользователю
    if ($fd = fopen($file, 'rb')) {
      while (!feof($fd)) {
        print fread($fd, 1024);
      }
      fclose($fd);
    }
    exit;
  } else header('Location: '.SITE_URL);
}
//Функция выдачи URL
static function get_url($url = NULL) {
	$u = (!defined('SITE_URL')) ? 'http://dnfile.ru/' : SITE_URL;
	return $u.$url;
}
//Функция вывода изображения
static function get_icon($img) {
	$u = (!defined('SITE_URL')) ? 'http://dnfile.ru/' : SITE_URL;
	$path = $u.'templates/default/img/'.$img;
	return $path;
}
//Функция отправки Email
static function send_mail($to,$subject,$message,$file = FALSE) {  
   $from = 'mail@dnfile.ru'; 
   if (empty($subject)) $subject = 'Регистрация на сайте dnfile.ru'; 
   $subject = '=?utf-8?b?'. base64_encode($subject) .'?='; 
   $headers = "Content-type: text/plain; charset=\"utf-8\"\r\n"; 
   $headers .= "From: <". $from .">\r\n"; 
   $headers .= "MIME-Version: 1.0\r\n"; 
   $headers .= "Date: ". date('D, d M Y h:i:s O') ."\r\n"; 
   return mail($to,$subject,$message,$headers,'-f'.$from);
}
//Функция отправки Email с вложением
static function send_mail_file($to,$subject,$message,$file,$filename = FALSE) {
	$filepath = $_SERVER['DOCUMENT_ROOT'].$file;
	if (!$filename) $filename = basename($file);
	 $from = 'mail@dnfile.ru'; 
    if (empty($subject)) $subject = 'Регистрация на сайте dnfile.ru';
	$subject = '=?utf-8?b?'. base64_encode($subject) .'?='; 
	//исьмо с вложением состоит из нескольких частей, которые разделяются разделителем
	$boundary = '--'.md5(uniqid(time())); 
	//$mailheaders = "Content-type: text/plain; charset=\"utf-8\"\r\n";
	// генерируем разделитель
	$mailheaders = "MIME-Version: 1.0;\n"; 
	$mailheaders .="Content-Type: multipart/mixed; boundary=\"$boundary\"\n"; 
	// разделитель указывается в заголовке в параметре boundary 

	$mailheaders .= "From: Dnfile.ru <$from>\n"; 

	$multipart = "--$boundary\n"; 
	$multipart .= "Content-Type: text/html; charset=\"utf-8\"\n";
	$multipart .= "Content-Transfer-Encoding: base64\n";    
	$multipart .= "\n";
	$multipart .= chunk_split(base64_encode($message));
	// первая часть само сообщение
	 
	// Закачиваем файл 
		$fp = fopen($filepath,"r"); 
			if (!$fp) return FALSE;
	$file = fread($fp, filesize($filepath)); 
	fclose($fp); 
	// чтение файла


	$message_part = "\n--$boundary\n"; 
	$message_part .= "Content-Type: application/octet-stream; name=\"$filename\"\n";  
	$message_part .= "Content-Transfer-Encoding: base64\n"; 
	$message_part .= "Content-Disposition: attachment; filename=\"$filename\"\n"; 
	$message_part .= "\n";
	$message_part .= chunk_split(base64_encode($file));
	$message_part .= "\n--$boundary--\n";
	// второй частью прикрепляем файл, можно прикрепить два и более файла

	$multipart .= $message_part;

	return mail($to,$subject,$multipart,$mailheaders);
}
}
?>