<?php
/**********************************
#
	Контроллер главной страницы
			by Kemel
#
**********************************/
class Controller_User {
	public $title = 'Пользователь';

/*
	Просмотр пользователя
*/
	public function action_index() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[2]) and is_numeric($routes[2])) ? (int)$routes[2] : FALSE;
		if (!$id and defined('IS_USER')) $id = IS_USER;
		if ($id and $user = $db -> query("SELECT * FROM `users` WHERE `user_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
			foreach ($user as $k => $v) Template::set($k,htmlspecialchars($v));	//Данные о пользователе
			$f_count = $db -> query("SELECT COUNT(*) FROM `files` WHERE `user_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_NUM);
			Template::set('f_count',$f_count[0]);
			Template::display('profile.html');
		} else {
			header('Location: '.Core::get_url());
			return;			
		}
	}
/*
	Просмотр папок пользователя
*/
	public function action_dirs() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if (!$id and defined('IS_USER')) $id = IS_USER;
		if ($id and $user = $db -> query("SELECT * FROM `users` WHERE `user_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
			foreach ($user as $k => $v) Template::set($k,htmlspecialchars($v));	//Данные о пользователе
			$f_count = $db -> query("SELECT COUNT(*) FROM `files` WHERE `user_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_NUM);
			$dirs = $db -> query("SELECT * FROM `user_dirs` WHERE `user_id` = '".$id."'") -> fetchAll();
			Template::set('dirs',$dirs);
			Template::set('f_count',$f_count[0]);
			Template::display('dirs.html');
		} else {
			header('Location: '.Core::get_url());
			return;			
		}
	}
/*
	Выход
*/
	public function action_exit() {
		if (defined('IS_USER')) {
		unset($_SESSION['user_id']);
		unset($_SESSION['password']);
		if (isset($_COOKIE['user_id'])) setcookie('user_id','');
		if (isset($_COOKIE['user_password'])) setcookie('user_password','');
		}
		header('Location: '.Core::get_url());
		return;
	}
/*
	Страница авторизации
*/
	public function action_auth() {
		global $db;
		if (empty($_POST['email']) or empty($_POST['password'])) {
		Template::display('auth.html');
		} else {
			$password = base64_encode($_POST['password']);
			$m = $db -> prepare("SELECT `user_id` FROM `users` WHERE `email` = ? AND `password` = ? LIMIT 1");
			$m -> bindValue(1,$_POST['email'],PDO::PARAM_STR);
			$m -> bindValue(2, $password, PDO::PARAM_STR);
			$m -> execute();
			if ($user = $m -> fetch(PDO::FETCH_ASSOC)) {
				$_SESSION['user_id'] = $user['user_id'];
				$_SESSION['password'] = $password;
				if (isset($_POST['memory'])) {	//Запоминаем пользователя
                    setcookie('user_id', $user['user_id'], time() + 3600 * 24 * 365);
                    setcookie('user_password', $password, time() + 3600 * 24 * 365);
				}
				header('Location: '.Core::get_url());
				return;
			} else {
				Template::set('err',true);
				Template::display('auth.html');
			}
		}
	}

/*
	Регистрация нового пользователя
*/
	public function action_registration() {
		global $db;
		Template::set('site_sub_title','Регистрация пользователя');
		if (empty($_POST['email']) or empty($_POST['password']) or empty($_POST['rand_code']) or empty($_POST['username'])) {
			$_SESSION['rand_code'] = mt_rand(1000,9999);
			Template::display('registration.html');
		} else {
			if (!filter_var($_POST['email'],FILTER_VALIDATE_EMAIL)) {
				$_SESSION['rand_code'] = mt_rand(1000,9999);
				Template::set('err_email',true);
				Template::display('registration.html');
				return;
			} elseif ($_SESSION['rand_code'] != $_POST['rand_code']) {
				$_SESSION['rand_code'] = mt_rand(1000,9999);
				Template::set('err_code',true);
				Template::display('registration.html');
				return;
			} elseif (!preg_match("#^([A-z0-9])+$#ui", $_POST['username']) or strlen($_POST['username']) < 4) {
				$_SESSION['rand_code'] = mt_rand(1000,9999);
				Template::set('err_username',true);
				Template::display('registration.html');
				return;
			}
			$username = trim(mb_substr($_POST['username'],0,40));
			$email = trim(mb_substr($_POST['email'],0,100));
			$m = $db -> prepare("SELECT `user_id` FROM `users` WHERE `email` = ? OR `username` = ? LIMIT 1");
			$m -> bindValue(1, $email, PDO::PARAM_STR);
			$m -> bindValue(2, $username, PDO::PARAM_STR);
			$m -> execute();
			if ($m -> fetch(PDO::FETCH_ASSOC)) {
				$_SESSION['rand_code'] = mt_rand(1000,9999);
				Template::set('err_isset_email',true);
				Template::display('registration.html');
				return;				
			}
			$sql = $db -> prepare("INSERT INTO `users` (email,username,password,time_reg) VALUES (:email,:username,:password,:time_reg)");
			$sql -> execute(array('email' => $email,'username' => $username,'password' => base64_encode($_POST['password']),'time_reg' => time()));
			$msg = "Здравствуйте!\r\nВаш аккаунт успешно зарегистрирован на сайте ".SITE_URL.".\r\nВаш логин: ".htmlspecialchars($username)."\r\nВаш пароль:".htmlspecialchars($_POST['password']."\r\n С уважением команда ".SITE_TITLE);
			Core::send_mail($_POST['email'],'Регистрация на сайте '.SITE_TITLE,$msg);
			Template::set('email',htmlspecialchars($_POST['email']));
			Template::set('password',htmlspecialchars($_POST['password'],ENT_QUOTES,'UTF-8'));
			Template::set('username',htmlspecialchars($username));
			Template::display('registration_ok.html');
			$_SESSION['user_id'] = $db -> LastInsertId();
			$_SESSION['user_password'] = base64_encode($_POST['password']);
			unset($_SESSION['rand_code']);
		}
	}
}
?>