<?php
/**********************************
#
	Контроллер главной страницы
			by Kemel
#
**********************************/
class Controller_Main {
	public $title = 'Главная страница';

/*
	Главная страница сайта
*/
	public function action_index() {
		global $db;
		//Берем 5 последних файлов
		if ($files = $db -> query("SELECT `file_id`,`name`,`title`,`file_size` FROM `files` ORDER BY `file_id` DESC LIMIT 0,5") -> fetchAll(PDO::FETCH_ASSOC)) Template::set('files',$files);
		$ext = $db -> query("SELECT * FROM `file_types` ORDER BY `type`") -> fetchAll(PDO::FETCH_ASSOC);
		Template::set('ext',$ext);
		Template::set('site_main_page',TRUE);
		Template::display('index.html');
	}
/*
	Просмотр папок
*/
	public function action_dirs() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if ($id and $dir = $db -> query("SELECT `dir_id`,`dir_sub_id`,`title`,`ext` FROM `dirs` WHERE `dir_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
			$files = array();
			if (!empty($dir['ext'])) {
				if ($dir['ext'] != '*') {
				//Берем типы файлов директории
				$types = explode('|',$dir['ext']);
				$type = '';
				foreach ($types as $k) $type .= "'".$k."',";
				$type = substr($type,0,-1);
				//Подсчитаем общее кол-во файлов
				$f_count = $db -> query("SELECT COUNT(*) FROM `files` WHERE `file_type` IN (".$type.") LIMIT 1") -> fetch(PDO::FETCH_NUM);
				} else $f_count = $db -> query("SELECT COUNT(*) FROM `files` WHERE 1 LIMIT 1") -> fetch(PDO::FETCH_NUM);
				if ($f_count[0] > 0) {
				# Подключаем класс постраничной навигации
				$pagination = new Pagination($f_count[0],10,Core::get_url('main/dirs/'.$id.'/'));
				if ($dir['ext'] != '*') 
				$files = $db -> query("SELECT `file_id`,`name`,`time`,`file_size` FROM `files` WHERE `file_type` IN (".$type.") ORDER BY `file_id` DESC LIMIT ". $pagination->skip().",". $pagination->take()) -> fetchAll(PDO::FETCH_ASSOC);
				else 
				$files = $db -> query("SELECT `file_id`,`name`,`time`,`file_size` FROM `files` WHERE 1 ORDER BY `file_id` DESC LIMIT ". $pagination->skip().",". $pagination->take()) -> fetchAll(PDO::FETCH_ASSOC);
				//exit(print_r($files));
				Template::set('f_count',$f_count[0]);
				Template::set('files',$files);
				Template::set('pages',$pagination -> get());
				}
			}
			Template::set('dir',$dir);
			Template::display('dir_view.html');
		} else {
			//Выводим список
			$dirs = $db -> query("SELECT `dir_id`,`title` FROM `dirs` WHERE `dir_sub_id` = '0' ORDER BY `time`") -> fetchAll(PDO::FETCH_ASSOC);
			Template::set('dirs',$dirs);
			Template::display('dirs.html');
		}
	}

/*
	Поиск файла
*/
	public function action_search() {
		global $db;
		$name = !empty($_POST['search']) ? '%'.$_POST['search'].'%' : FALSE;
		if ($name) {
			$sql = $db -> prepare("SELECT `file_id`,`name`,`file_size` FROM `files` WHERE `name` LIKE ? ORDER BY `file_id`");
			$sql -> bindValue(1, $name, PDO::PARAM_STR);
			$sql -> execute();
			$files = $sql->fetchAll(PDO::FETCH_ASSOC);
			Template::set('files',$files);
			Template::display('search.html');
		} else {
			header('location:'.Core::get_url());
			return;
		}
	}
/*
	Скачивание файла
*/
	public function action_download() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if ($id and $file = $db -> query("SELECT `file_password`,`file_path`,`name` FROM `files` WHERE `file_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
		if (!empty($file['file_password'])){
			if ($_SESSION[$id.'_password'] != $file['file_password']) {
				Template::set('file_id',$id);
				Template::display('file_input_password.html');
				return;
			}
		}
		$db -> query("UPDATE `files` SET `time_last` = '".time()."',`loads` = (`loads`+1) WHERE `file_id` = '".$id."' LIMIT 1");	//+1 к загрузке
		$mime = $db -> query("SELECT `mime` FROM `file_types` WHERE `type` = '".$file['type']."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC);
		$path = substr(ROOTPATH,0,strlen(ROOTPATH)-1).$file['file_path'];
		$name = (!empty($file['name']) ? htmlspecialchars($file['name'],ENT_QUOTES,'UTF-8') : NULL);
		Core::file_force_download($path,$name,$mime['mime']);
		} else {
			Template::display('file_not_found.html');
		}
	}
/*
	Отдаем содержимое в браузер без сохранения
*/
	public function action_comments() {
		//exit;
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if ($id and $file = $db -> query("SELECT `file_id`,`name` FROM `files` WHERE `file_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
			$err_add = FALSE;
			if (!empty($_POST['text']) and !empty($_POST['name'])) {	//Добавляем комментарий
				if (isset($_SESSION['comment_time'])) {
					if (time() < $_SESSION['comment_time'] + 10) $err_add = TRUE;
				}
				if (!$err_add) {
				$name = mb_substr($_POST['name'],0,45);
				$user_id = defined(IS_USER) ? IS_USER : '0';
				$sql = $db -> prepare("INSERT INTO comments (file_id,user_id,name,text,time) VALUES (:file_id,:user_id,:name,:text,:time)");
				$sql -> execute(array('file_id' => $id,'user_id' => $user_id,'name' => $name,'text' => mb_substr($_POST['text'],0,400),'time' => time()));
				$_SESSION['comment_time'] = time();
				}
			}
			$comments = $db -> query("SELECT * FROM `comments` WHERE `file_id` = '".$id."' ORDER BY `comment_id` DESC") -> fetchAll(PDO::FETCH_ASSOC);
			Template::set('err_add',$err_add);
			Template::set('comments',$comments);
			Template::set('file',$file);
			Template::display('file_comments.html');
		} else {
			Template::display('file_not_found.html');
		}
	}
/*
	Отправка файла на почту
*/
	public function action_sendmail() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if ($id and $file = $db -> query("SELECT * FROM `files` WHERE `file_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
		if (!empty($file['file_password'])){
			if ($_SESSION[$id.'_password'] != $file['file_password']) {
				Template::set('file_id',$id);
				Template::display('file_input_password.html');
				return;
			}
		}
			if (!empty($_POST['mail'])) {
				if (!filter_var($_POST['mail'],FILTER_VALIDATE_EMAIL)) {
					Template::set('error_email',1);
				} else {
					include $_SERVER['DOCUMENT_ROOT']."/system/includes/libmail/libmail.php"; // вставляем файл с классом
					/*	$m= new Mail; // начинаем 
						$m->From( "mail@dnfile.ru" ); // от кого отправляется почта 
						$m->To( $_POST['mail'] ); // кому адресованно
						$m->Subject( "Мобильный файлообменник dnfile.ru" );
						$m->Body( 'Вам отправлен файл с сайта dnfile.ru - '.$file['name'] );    
						$m->Priority(3) ;    // приоритет письма
						$m->Attach( $_SERVER['DOCUMENT_ROOT'].$file['file_path'] ) ; // прикрепленный файл */
					if (Core::send_mail_file($_POST['mail'],'Файл с сайта Dnfile.ru','Вам отправлен файл с сайта dnfile.ru - '.$file['name'],$file['file_path'],$file['name'])) Template::set('success',1);
					//if ($m -> send()) Template::set('success',1);
					else {
						//exit;
						Template::set('error_email',1);
					}
				}
			}
			Template::set('file_id',$id);
			Template::set('name',htmlspecialchars($file['name']));
			Template::display('send_mail.html');
		} else {
			Template::display('file_not_found.html');
		}
	}
/*
	Просмотр файла
*/
	public function action_view() {
		global $db;
		$routes = explode('/', $_SERVER['REQUEST_URI']);
		$id = (!empty($routes[3]) and is_numeric($routes[3])) ? (int)$routes[3] : FALSE;
		if ($id and $file = $db -> query("SELECT * FROM `files` WHERE `file_id` = '".$id."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC)) {
			if (!empty($file['file_password'])) {
				if ($_SESSION[$file['file_id'].'_password'] != $file['file_password']) {
				if (!isset($_POST['password'])) {
					Template::set('file_id',$id);
					Template::display('file_input_password.html');
					return;
				} elseif(base64_encode($_POST['password']) != $file['file_password']) {
					Template::set('file_id',$id);
					Template::set('password_error',$id);
					Template::display('file_input_password.html');
					return;
				} else $_SESSION[$file['file_id'].'_password'] = base64_encode($_POST['password']);
				}
			}
			//Смотрим кто загрузил
			$user_name = FALSE;
			if ($file['user_id']) {
				$us = $db -> query("SELECT `username` FROM `users` WHERE `user_id` = '".$file['user_id']."' LIMIT 1") -> fetch(PDO::FETCH_ASSOC);
				$user_name = !empty($us['username']) ? htmlspecialchars($us['username'],ENT_QUOTES,'UTF-8') : 'Неизвестный';
			}
			Template::set('user_name',$user_name);
			//+1 к просмотру страницы
			$db -> query("UPDATE `files` SET `view` = (`view`+1) WHERE `file_id` = '".$id."' LIMIT 1");
			//Вытаскиваем комменты
			$comments = $db -> query("SELECT COUNT(*) FROM `comments` WHERE `file_id` = '".$id."'") -> fetch(PDO::FETCH_NUM);
			Template::set('comments',$comments);
			if (!empty($file['title'])) Template::set('site_sub_title',htmlspecialchars($file['title'],ENT_QUOTES,'UTF-8'));	//Устанавливаем sub title
			foreach ($file as $k => $v) Template::set($k,htmlspecialchars($v));	//Данные о файле
			if ($file['file_type'] == 'jpg' || $file['file_type'] == 'png' || $file['file_type'] == 'gif' || $file['file_type'] == 'jpeg'){
				$f_path = ROOTPATH.$file['file_path'];
				$f_type = exif_imagetype($f_path);
				if( $f_type == IMAGETYPE_JPEG || $f_type == IMAGETYPE_PNG || $f_type == IMAGETYPE_GIF) {
				$image_path = '/temp/preview/'.$file['file_id'].'.'.$file['file_type'];
				if (!file_exists($image_path)) {
					include_once ROOTPATH.'system/includes/simple_image.php';
					$image = new SimpleImage();
					$image->load($f_path);
					$image->resizeToWidth(200);
					$image->save(ROOTPATH.$image_path);
				}
				Template::set('image_path',$image_path);
				}
			}
			Template::set('site_sub_title',htmlspecialchars(mb_substr($file['name'],0,20),ENT_QUOTES,'UTF-8'));
			Template::display('file_view.html');
		} else {
			Template::display('file_not_found.html');
		}
	}
	
/*
	Загрузка файла
*/
	public function action_load() {
		global $db;
		if (isset($_FILES['file']['name']) and is_uploaded_file($_FILES['file']['tmp_name'])) {	//Проверка на существование файла
			//Определяем расширение файла
			$ext = strtolower(pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION));
			$file_types = $db -> query("SELECT `type`,`size` FROM `file_types`") -> fetchAll(PDO::FETCH_KEY_PAIR);
			if (array_key_exists($ext,$file_types)) {
				$size = (int)$_FILES['file']['size'];
				if ($size <= $file_types[$ext]) {
					$strlen = mb_strlen($_FILES['file']['name']);
					$name = ($strlen > 95) ? mb_substr($_FILES['file']['name'],0,95).'.'.$ext : $_FILES['file']['name'];	//Если имя больше 45 символов
					$file_name = Core::name_rnd(12).'.'.$ext;	//Рандомное имя
					$ip = Core::getip();	//Определяем ip адрес
					$agent = Core::get_user_agent();	//Определяем браузер
					if (!is_dir(ROOTPATH.'files/'.$ext)) mkdir(ROOTPATH.'files/'.$ext);	//Проверяем папку с расширением
					$dir = ROOTPATH.'files/'.$ext.'/'.date('m');
					if (!is_dir($dir)) {	//Папка с месяцем загрузки
						mkdir($dir);
					}
					//Проверим был ли загружен файл неск секунд назад
				//	$t = $db -> prepare("SELECT `file_id`");
					if (isset($_SESSION['time_upload'])) {
						if (time() <= $_SESSION['time_upload'] + 10) $err_time = true;
					}
					$path = $dir.'/'.$file_name;
					$file_path = '/files/'.$ext.'/'.date('m').'/'.$file_name;
					if (!$err_time) {
					if (move_uploaded_file($_FILES['file']['tmp_name'],$path)) {	//Загружаем файл
						$password = (!empty($_POST['password'])) ? base64_encode(trim($_POST['password'])) : '';
						$desc = isset($_POST['desc']) ? mb_substr($_POST['desc'],0,150) : '';
						if (defined('IS_USER')) {
							$sql = $db -> prepare("INSERT INTO files (user_id,file_name,file_password,file_path,file_type,file_size,name,time,ip,user_agent,description) VALUES (:user_id,:file_name,:file_password,:file_path,:file_type,:file_size,:name,:time,:ip,:user_agent,:description)");
							$sql -> execute(array('user_id' =>IS_USER,'file_name' => $file_name,'file_password' => $password,'file_path' => $file_path,'file_type' => $ext,'file_size' => $size,'name' => $name,'time' => time(),'ip' => $ip,'user_agent' => $agent,'description' => $desc));
						} else {
							$sql = $db -> prepare("INSERT INTO files (file_name,file_password,file_path,file_type,file_size,name,time,ip,user_agent,description) VALUES (:file_name,:file_password,:file_path,:file_type,:file_size,:name,:time,:ip,:user_agent,:description)");
							$sql -> execute(array('file_name' => $file_name,'file_password' => $password,'file_path' => $file_path,'file_type' => $ext,'file_size' => $size,'name' => $name,'time' => time(),'ip' => $ip,'user_agent' => $agent,'description' => $desc));
						}
						$p = SITE_URL.$db -> LastInsertId();
						Template::set('path',$p);
						Template::display('uploaded.html');
						$_SESSION['time_upload'] = time();
					} else {
						Template::display('error_upload.html');	//Ошибка загрузки файла
					}
					} else {
						Template::set('err_time',$err_time);
						Template::display('error_upload.html');
					}
				} else {
					Template::set('size',Core::get_filesize($size));
					Template::display('error_size.html');	//Большой размер файла
				}
			} else {
				Template::set('ext',implode(array_keys($file_types),','));
				Template::display('error_types.html');	//Сообщение об ошибке типа файла
			}
		} else {
			Template::display('error_isset.html');	//Не выбран файл
		}
	}
}
?>