<?php

function _pluralize($num, array $forms = []) {
	
	return 3 == count($forms)
				? (1 == $num % 10 && 11 != $num % 100
							? @$forms[0]
							: ($num % 10 >= 2 && $num % 10 <= 4 && ($num % 100 < 10 || $num % 100 >= 20)
									? @$forms[1]
									: @$forms[2]))
				: null;
}

function _isMobile($user_agent) {
	
	$mobile_keywords = [
		'android',
		'iphone',
		'ipad',
		'opera mobi',
		'opera mini'
	];
	
	foreach($mobile_keywords as $keyword) {
		if (preg_match('/' . $keyword . '/i', $user_agent)) {
			return true;
		}
	}
	
	return false;
	
}

function _date() {
	
	/** @var [] */
	$args	=	func_get_args();
	
	$list	=	[
		'',
		'янв',
		'фев',
		'мар',
		'апр',
		'май',
		'июн',
		'июл',
		'авг',
		'сен',
		'окт',
		'ноя',
		'дек'
	];
	
	switch (count($args)) {
		case 1 :
			/** @var int */
			$timestamp	=	(int)$args[0];
			$m	=	date('n', $timestamp);
			return date('j'
						.	' '
						.	$list[ $m ]
						.	' Y в H:i', $timestamp);
		break;
		case 3 :
			return (int)$args[0] . ' ' . $list[(int)$args[1]] . ' ' . (int)$args[2];
		break;
	}
	
}

function _ago ($timestamp) {
	$delta = time() - $timestamp;
	if (0 == $delta) {
		return 'только что';
	} else if (0 < $delta && strtotime('-1 days') < $timestamp) {
		return _get_plural_time( $delta, 3 ) . ' назад';
	} else {
		return _date($timestamp);
	}
}

function _get_plural_time($delta, $case = 0) {
	
	$list_cases	=	[
		//	Именительный
		//	Кто?
		//	Что?
		[
			//	секунд
			[
				'а',
				'ы',
				''
			],
			//	минут
			[
				'а',
				'ы',
				''
			],
			//	час
			[
				'',
				'а',
				'ов'
			],
			//	д
			[
				'ень',
				'ня',
				'ней'
			]
		],
		//	Родительный
		//	Кого?
		//	Чего?
		[
			//	секунд
			[
				'ы',
				'',
				''
			],
			//	минут
			[
				'ы',
				'',
				''
			],
			//	час
			[
				'а',
				'ов',
				'ов'
			],
			//	д
			[
				'ня',
				'ней',
				'ней'
			]
		],
		//	Дательный
		//	Кому?
		//	Чему?
		[
			//	секунд
			[
				'е',
				'ам',
				'ам'
			],
			//	минут
			[
				'е',
				'ам',
				'ам'
			],
			//	час
			[
				'у',
				'ам',
				'ам'
			],
			//	д
			[
				'ню',
				'ням',
				'ням'
			]
		],
		//	Винительный
		//	Кого?
		//	Что?
		[
			//	секунд
			[
				'у',
				'ы',
				''
			],
			//	минут
			[
				'у',
				'ы',
				''
			],
			//	час
			[
				'',
				'а',
				'ов'
			],
			//	д
			[
				'ень',
				'ня',
				'ней'
			]
		],
		//	Творительный
		//	Кем?
		//	Чем?
		[
			//	секунд
			[
				'ой',
				'ами',
				'ами'
			],
			//	минут
			[
				'ой',
				'ами',
				'ами'
			],
			//	час
			[
				'ом',
				'ами',
				'ами'
			],
			//	д
			[
				'нём',
				'ями',
				'ями'
			]
		],
		//	Предложный
		//	О ком?
		//	О чем?
		[
			//	секунд
			[
				'е',
				'ах',
				'ах'
			],
			//	минут
			[
				'е',
				'ах',
				'ах'
			],
			//	час
			[
				'е',
				'ах',
				'ах'
			],
			//	д
			[
				'не',
				'нах',
				'нях'
			]
		]
	];
	
	if (60 > $delta) {
		return (1 == $delta
					? ''
					: $delta . ' ')
		. 'секунд'
		. _pluralize($delta, $list_cases[ $case ][0]);
	} else if (60 <= $delta && 60 * 60 > $delta) {
		$count	=	@floor($delta / 60);
		return (1 == $count
						? ''
						: $count . ' ') . 'минут'
			. _pluralize( $count, $list_cases[ $case ][1] );
	} else if (60*60 <= $delta && (24*60*60) > $delta) {
		$count	=	@floor($delta/(60*60));
		return (1 == $count
						? ''
						: $count . ' ') . 'час'
			. _pluralize( $count, $list_cases[ $case ][2] );
	} else {
		$count	=	@floor($delta/(24*60*60));
		return (1 == $count
						? ''
						: $count . ' ') . 'д'
			. _pluralize( $count, $list_cases[ $case ][3] );
	}
	
}

function _along_time($delta) {
	
	
	$times = [
		24*60*60,
		60*60,
		60
	];
	
	$offset	=	0;
	$output = [];
	
	while ($offset < count($times)) {
		
		//	time
		$t	=	$times[ $offset ];
		
		$c	=	@floor($delta / $t);
		
		$s	=	$c * $t;
		$delta	-=	$s;
		if (0 < $c) {
			$output[]	=	_get_plural_time($s, 3);
		}
		
		$offset++;
		
	}
	
	$output[]	=	_get_plural_time($delta, 3);
	
	return implode(', ', $output);
	
}

function _isleapyear($year) {
	return (!($year % 4) && ($year % 100)) || (!($year % 400)) ? true : false;
}

function _age($d, $m, $y) {
	
	$now_d	=	date('j');
	$now_m	=	date('n');
	$now_y	=	date('Y');
	
	if ($now_y < $y) {
		return 0;
	}
	
	$age	=	$now_y - $y;
	if ($now_m < $m || $now_m == $m && $now_d < $d) {
		$age--;
	}
	
	return $age;
	
}

function _text($string, $limit = false) {
	
	if ($limit && $limit < \framework\lang\String::length($string))
		$string	=	\framework\lang\String::substring($string, 0, $limit) . '..';
	
	$handlers	=	new \bbcode\HandlerCollection();
	$handlers->set(null, function($node) {
		
		$content	=	$node->getContent();
		
		//$chars	=	[
		//	'@lb;'	=>	'&#91;',
		//	'@rb;'	=>	'&#93;'
		//];
		
		//$content	=	str_replace(array_keys($chars), array_values($chars), $content);
		$content	=	@preg_replace_callback(
				'/'
			.	'(^|\s+)'
			.	'(https?\:\/\/[^\s\t\r\n$`\'\"]+)'
			.	'($|\s*?)'
			.	'/ui', function($matches) {
			$url = $matches[2];
			return ' <a href="' . $url . '">' . $url . '</a> ';
		}, $content);
		
		$content	=	nl2br($content);
		
		return $content;
		
	});
	
	$handlers->set('b', function($node) {
		$content	=	$node->getContent();
		return '<b>' . $content . '</b>';
	});
	$handlers->set('u', function($node) {
		$content	=	$node->getContent();
		return '<u>' . $content . '</u>';
	});
	$handlers->set('i', function($node) {
		$content	=	$node->getContent();
		return '<i>' . $content . '</i>';
	});
	
	//	Цитата
	$handlers->set('q', function($node) {
		$content	=	$node->getContent();
		/** @var [] */
		$attrs		=	$node->getAttrs();
		return '<div class="q">'
					.	'Цитата <b>' . @$attrs['q'] . '</b>:'
					.	'<br />' . $content
					.	'</div>';
	});
	
	$handlers->set('url', function($node) {
		$content	=	$node->getContent();
		$attrs		=	$node->getAttrs();
		if (isset($attrs['url'])) {
			$url	=	$attrs['url'];
			return preg_match('/^https?/i', $url) || '/' == substr($url, 0, 1) ? '<a href="' . $url . '">' . $content . '</a>' : $content;
		} else {
			return $content;
		}
	});
	
	$parser	=	new \bbcode\Parser\Parser(
		new \bbcode\Syntax\Syntax(),
		$handlers
	);
	
	return $parser->parse($string)->handle();
	
}

function _user($row) {
	
	if (!is_array($row) ||
			!isset($row['id']))
		return 'Удалён';
	
	$output	=	[];
	$output[]	=	'<img src="' . (1 == $row['sex']
							? (time() - $row['last_updated_at'] < 60*15 ? '/public/assets/images/f.png' : '/public/assets/images/foff.png')
							: (time() - $row['last_updated_at'] < 60*15 ? '/public/assets/images/m.png' : '/public/assets/images/moff.png')) . '" alt="" />';
	
	if (isset($row['color']) && false !== strpos($row['color'], ',')) {
		/** @var [] */
		$colors	=	explode(',', $row['color']);
		$output[]	=	'<a href="/user/?id=' . $row['id'] . '"><b>' . _gradient_text($row['login'], $colors[0], $colors[1]) . '</b></a>';
	} else
		$output[]	=	'<a href="/user/?id=' . $row['id'] . '" style="color : #' . (isset($row['color']) ? $row['color'] : '000000') . ';"><b>' . $row['login'] . '</b></a>';
	
	switch ($row['level']) {
		case 1 :
			$output[]	=	'(Mod)';
		break;
		case 2 :
			$output[]	=	'(Adm)';
		break;
		case 3 :
			$output[]	=	'(SV!)';
		break;
	}
	
	return implode(' ', $output);
	
}

function _e($string) {
	return htmlentities($string, ENT_QUOTES);
}

function _gradient_text() {
	
	/** @var [] */
	$args	=	func_get_args();
	$string	=	new \framework\lang\String($args[0]);
	/** @var [] */
	$start	=	\Color::hex2intarray($args[1]);
	/** @var [] */
	$end	=	\Color::hex2intarray($args[2]);
	$levels	=	\framework\lang\String::length($string->__toString());
	$i		=	0;
	$output	=	[];
	
	for ( ; $i < $levels; $i++ ) {
		
		$colors	=	[];
		$j	=	0;
		for ( ; $j < 3; $j++ )
			$colors[]	=	\Color::int2hex(min(255, round($start[$j]-(round(($start[$j]-$end[$j])/$levels)*$i))));
		
		$output[]	=	'<span style="color : #' . implode($colors) . ';">' . $string[$i] . '</span>';
		
	}
	
	return implode($output);
	
}