<?php

namespace controllers;

use framework\Controller;
use framework\http\Cookie;

/**
 *	@author 3kZO
 */
class ProfileController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if (!$this->app['auth']->isLoggedIn())
			$this->redirect('/');
		
	}
	
	public function index() {
		
		$this->render('document', [
			'title'		=>	'Личный кабинет',
			'content'	=>	$this->renderTemplate('profile/index', [
				
			])
		]);
		
	}
	
	public function view() {
		
		$st	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
			(int)$this->request->query->get('id')
		]);
		//if (0 == $st->rowCount())
		//	$this->redirect('/');
		
		/** @var [] */
		$row	=	$st->fetch();
		
		$this->render('document', [
			'title'		=>	$row['login'],
			'content'	=>	$this->renderTemplate('profile/view', [
				'row'	=>	$row
			])
		]);
		
	}
	
}