<?php

namespace controllers;

use framework\Controller;
use framework\lang\String;

/**
 *	@author 3kZO
 */
class ChatController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if (!$this->app['auth']->isLoggedIn())
			$this->redirect('/user/signIn');
		
	}
	
	/**
	 *	@route("/users")
	 */
	public function index() {
		
		if (0 == $this->app['db']->executeQuery('SELECT COUNT(u.user_id) FROM chat_in u WHERE u.user_id=?;', [
			$this->app['auth']->getUser()['id']
		])->fetchColumn())
			$this->app['db']->executeQuery('INSERT INTO chat_in
				(user_id, last_updated_at) VALUES (?, UNIX_TIMESTAMP());', [
					$this->app['auth']->getUser()['id']
				]);
		
		$this->app['db']->executeQuery('UPDATE chat_in
			SET last_updated_at=UNIX_TIMESTAMP() WHERE user_id=?;', [
			$this->app['auth']->getUser()['id']
		]);
		
		$items		=	$this->app['db']->executeQuery('SELECT COUNT(c.id) FROM chat c;')->fetchColumn();
		$items_per_page	=	$this->app['auth']->getUser()['items_per_page'];
		$pager		=	new \Pager(
			$this->request->query->get('page'),
			$items,
			$items_per_page,
			function ($page) {
				return '/chat/?page=' . $page;
			}
		);
		
		$message_list	=	[];
		foreach ($this->app['db']->executeQuery('SELECT c.* FROM chat c ORDER BY c.id DESC LIMIT ' . $pager->getOffset() . ', ' . $items_per_page . ';')->fetchAll() as $row) {
			$row['user']	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
				$row['user_id']
			])->fetch();
			$message_list[]	=	$row;
		}
		
		$target	=	null;
		if (null !== $this->request->query->get('reply')) {
			$st	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE id=?;', [
				(int)$this->request->query->get('reply')
			]);
			if (0 == $st->rowCount())
				$this->redirect('/chat/');
			/** @var [] */
			$target	=	$st->fetch();
			
		}
		
		$errors	=	[];
		if ($this->request->isPost() &&
					$this->app['security']->isValid($this->request->request->get('csrf_token')) &&
					0 != String::length($this->request->request->get('text'))) {
			if (2 > String::length($this->request->request->get('text')))
				$errors[]	=	'Слишком короткое сообщение';
			if (0 == count($errors)) {
				$this->app['db']->executeQuery('INSERT INTO chat (user_id, text, created_at) VALUES (?, ?, UNIX_TIMESTAMP());', [
					$this->app['auth']->getUser()['id'],
					_e($this->request->request->get('text'))
				]);
				$this->redirect('/chat/');
			}
		}
		
		$this->render('document', [
			'title'		=>	'Чат',
			'content'			=>	$this->renderTemplate('chat/index', [
				'message_list'	=>	$message_list,
				'pager'			=>	$pager,
				'errors'		=>	$errors,
				'target'		=>	$target
			])
		]);
		
	}
	
}