<?php

/**
 *	@author 3kZO
 */

define('ROOT', str_replace(DIRECTORY_SEPARATOR, '/', __DIR__));
require ROOT . '/protected/framework/Autoloader.php';
require ROOT . '/protected/functions.php';

use framework\Autoloader;
use framework\App;

Autoloader::setNamespace('framework',
	ROOT . '/protected/framework');
Autoloader::addDir([
	ROOT . '/protected/framework/libs',
	ROOT . '/protected/app'
]);

Autoloader::setNamespace('bbcode',
	ROOT . '/protected/framework/vendor/bbcode/src');

spl_autoload_register(function($class) {
	Autoloader::load($class);
});

$app = new App(function($c) {
	$c['_db']		=	[
		'mysql:host=localhost;dbname=lol',
		'root',
		''
	];
	$c['_tplDir']	=	ROOT . '/protected/app/templates';
	$c['_cacheDir']	=	ROOT . '/protected/app/cache';
	$c->register(new \framework\providers\SessionServiceProvider());
	$c->register(new \framework\providers\TemplateServiceProvider());
	$c->register(new \framework\providers\DbServiceProvider());
	$c->register(new \framework\providers\CacheServiceProvider());
	$c->register(new \framework\providers\AuthServiceProvider());
	$c->register(new \framework\providers\SecurityServiceProvider());
});

$app->route('/', 'controllers\WelcomeController::index');
$app->route('/user/signIn', 'controllers\UserController::signIn');
$app->route('/user/signUp', 'controllers\UserController::signUp');
$app->route('/user/forgot', 'controllers\UserController::forgot');

$app->route('/user/index', 'controllers\ProfileController::index');
$app->route('/user', 'controllers\ProfileController::view');

$app->route('/forum', 'controllers\ForumController::index');
$app->route('/forum/subforum', 'controllers\ForumController::subforum');
$app->route('/forum/topic', 'controllers\ForumController::topic');
//$app->route('/forum/unread', 'controllers\ForumController::unread');
//$app->route('/forum/search', 'controllers\ForumController::search');
$app->route('/forum/reply', 'controllers\ForumController::reply');
$app->route('/forum/newTopic', 'controllers\ForumController::newTopic');

$app->route('/users', 'controllers\UsersController::index');
$app->route('/users/all', 'controllers\UsersController::all');

$app->route('/chat', 'controllers\ChatController::index');

try {
	$app->run();
} catch (\Exception $e) {
	//	
	echo $e->getMessage();
}
