<?php

namespace controllers;

use framework\Controller;
use framework\http\Cookie;

/**
 *	@author 3kZO
 */
class WelcomeController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if (!$this->app['auth']->isLoggedIn())
			$this->redirect('/user/signIn');
		
	}
	
	/**
	 *	@route("/")
	 */
	public function index() {
		
		if (null !== $this->request->query->get('exit'))
		{
			$this->response->setCookie(new Cookie('user', null, 0));
			$this->redirect('/user/signIn');
		}
		
		$this->render('document', [
			'title'		=>	'Добро пожаловать!',
			'content'	=>	$this->renderTemplate('index', [
				'total_topics'	=>	$this->app['db']->executeQuery('SELECT COUNT(t.id) FROM topics t;')->fetchColumn(),
				'total_posts'	=>	$this->app['db']->executeQuery('SELECT COUNT(p.id) FROM posts p;')->fetchColumn(),
				'last_topic_list'	=>	$this->app['db']->executeQuery('SELECT t.* FROM topics t ORDER BY t.last_updated_at DESC LIMIT 3;')->fetchAll(),
				'total_users'		=>	$this->app['db']->executeQuery('SELECT COUNT(u.id) FROM users u;')->fetchColumn(),
				'chat_in'		=>	$this->app['db']->executeQuery('SELECT COUNT(u.user_id) FROM chat_in u WHERE u.last_updated_at > UNIX_TIMESTAMP()-60;')->fetchColumn()
			])
		]);
		
	}
	
}