<?php

namespace controllers;

use framework\Controller;
use framework\lang\String;

/**
 *	@author 3kZO
 */
class UsersController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if (!$this->app['auth']->isLoggedIn())
			$this->redirect('/user/signIn');
		
	}
	
	/**
	 *	@route("/users")
	 */
	public function index() {
		
		$this->render('document', [
			'title'		=>	'Пользователи',
			'content'	=>	$this->renderTemplate('users/index', [
				
			])
		]);
		
	}
	
	/**
	 *	@route("/users/all")
	 */
	public function all() {
		
		$items		=	$this->app['db']->executeQuery('SELECT COUNT(u.id) FROM users u;')->fetchColumn();
		$items_per_page	=	$this->app['auth']->getUser()['items_per_page'];
		$pager		=	new \Pager(
			$this->request->query->get('page'),
			$items,
			$items_per_page,
			function ($page) {
				return '/users/all/?page=' . $page;
			}
		);
		
		$this->render('document', [
			'title'		=>	'Пользователи',
			'content'	=>	$this->renderTemplate('users/all', [
				'list'	=>	$this->app['db']->executeQuery('SELECT u.* FROM users u LIMIT ' . $pager->getOffset() . ', ' . $items_per_page . ';')->fetchAll(),
				'pager'	=>	$pager
			])
		]);
		
	}
	
}