<?php

namespace controllers;

use framework\Controller;
use framework\http\Cookie;
use framework\lang\String;

/**
 *	@author 3kZO
 */
class UserController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if ($this->app['auth']->isLoggedIn())
			$this->redirect('/');
		
	}
	
	/**
	 *	@route("/user/signIn")
	 */
	public function signIn() {
		
		$errors	=	[];
		if ($this->request->isPost() &&
				is_string($this->request->request->get('csrf_token')) &&
				$this->app['security']->isValid($this->request->request->get('csrf_token')) &&
				is_string($this->request->request->get('login')) &&
				0 != String::length($this->request->request->get('login')) &&
				is_string($this->request->request->get('password')) &&
				0 != String::length($this->request->request->get('password'))) {
			$st	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.login=?;', [
				$this->request->request->get('login')
			]);
			if (0 == $st->rowCount())
				$errors[]	=	'Нет такого пользователя';
			if (0 == count($errors)) {
				/** @var [] */
				$row	=	$st->fetch();
				if (md5(md5($row['id']) . md5($this->request->request->get('password'))) != $row['password'])
					$errors[]	=	'Неверный пароль';
				else if (isset($row['block']))
					$errors[]	=	'Пользователь заблокирован. Причина: ' . $row['block'];
				else {
					$token	=	md5(md5($row['id']) . md5(rand()));
					$this->app['db']->executeQuery('INSERT INTO sessions (user_id, token) VALUES (?,?);', [
						$row['id'],
						$token
					]);
					$this->response->setCookie(new Cookie('user', $token, time()+86400*7));
					$this->redirect('/');
				}
			}
		}
		
		$this->render('document', [
			'title'		=>	'Авторизация',
			'content'	=>	$this->renderTemplate('user/signIn', [
				'errors'	=>	$errors
			])
		]);
		
	}
	
	public function signUp() {
		
		$errors	=	[];
		
		if ($this->request->isPost() &&
				is_string($this->request->request->get('csrf_token')) &&
				$this->app['security']->isValid($this->request->request->get('csrf_token')) &&
				0 != String::length($this->request->request->get('login')) &&
				is_array($this->request->request->get('password')) &&
				2 == count($this->request->request->get('password')) &&
				0 != String::length($this->request->request->get('password')[0]) &&
				0 != String::length($this->request->request->get('password')[1]) &&
				is_array($this->request->request->get('birthday')) &&
				3 == count($this->request->request->get('birthday')) &&
				0 != String::length($this->request->request->get('birthday')[0]) &&
				0 != String::length($this->request->request->get('birthday')[1]) &&
				0 != String::length($this->request->request->get('birthday')[2])) {
			if (3 > String::length($this->request->request->get('login')))
				$errors[]	=	'Логин слишком короткий';
			if (20< String::length($this->request->request->get('login')))
				$errors[]	=	'Логин слишком длинный';
			if (!preg_match('/^[0-9a-zа-яё\._]+$/ui', $this->request->request->get('login')))
				$errors[]	=	'В логине присутствуют запрещенные символы';
			/** @var [] */
			$password	=	$this->request->request->get('password');
			if (6 > String::length($password[0]))
				$errors[]	=	'Пароль слишком короткий';
			if (30< String::length($password[0]))
				$errors[]	=	'Пароль слишком длинный';
			if (!preg_match('/^[0-9a-z]+$/i', @$password[0]))
				$errors[]	=	'В пароле присутствуют запрещенные символы';
			if (@$password[0] != @$password[1])
				$errors[]	=	'Пароли не совпадают';
			if (0 != $this->app['db']->executeQuery('SELECT COUNT(u.id) FROM users u WHERE u.login=?;', [
				$this->request->request->get('login')
			])->fetchColumn())
				$errors[]	=	'Логин занят';
			
			/** @var [] */
			$birthday	=	$this->request->request->get('birthday');
			if (0 >= (int)$birthday[0] ||
						0 >= (int)$birthday[1] ||
						0 >= (int)$birthday[2] ||
						2 == (int)$birthday[1] && (_isleapyear((int)$birthday[2]) && 29 < (int)$birthday[0] || 28 < (int)$birthday[0]) ||
						(int)$birthday[2]%2 && 31 < (int)$birthday[0])
				$errors[]	=	'Неверно указана дата рождения';
			
			if (0 == count($errors)) {
				$this->app['db']->executeQuery('INSERT INTO users (login, sex, created_at) VALUES (?,?,UNIX_TIMESTAMP());', [
					$this->request->request->get('login'),
					1 == (int)$this->request->request->get('sex') ? 1 : 0
				]);
				$id	=	$this->app['db']->lastInsertId();
				$password	=	md5(md5($id).md5($password[0]));
				$this->app['db']->executeQuery('UPDATE users SET password=? WHERE id=?;', [
					$password,
					$id
				]);
				$token	=	md5(md5($id).md5(rand()));
				$this->app['db']->executeQuery('INSERT INTO sessions (user_id, token) VALUES (?, ?);', [
					$id,
					$token
				]);
				$this->response->setCookie(new Cookie('user', $token, time()+86400*7));
				$this->redirect('/');
			}
		}
		
		$this->render('document', [
			'title'		=>	'Регистрация',
			'content'	=>	$this->renderTemplate('user/signUp', [
				'errors'	=>	$errors
			])
		]);
		
	}
	
	public function forgot() {
		
		$this->render('document', [
			'title'		=>	'Восстановление',
			'content'	=>	$this->renderTemplate('user/forgot', [
				
			])
		]);
		
	}
	
}