<?php

namespace controllers;

use framework\Controller;
use framework\lang\String;

/**
 *	@author 3kZO
 */
class ForumController extends Controller
{
	
	public function onBefore() {
		
		parent::onBefore();
		
		if (!$this->app['auth']->isLoggedIn())
			$this->redirect('/user/signIn');
		
	}
	
	/**
	 *	@route("/forum")
	 */
	public function index() {
		
		$section_list	=	[];
		foreach ($this->app['db']->executeQuery('SELECT s.* FROM sections s;')->fetchAll() as $row)
		{
			
			$row['subforum_list']	=	$this->app['db']->executeQuery('SELECT s.* FROM subforums s WHERE s.section_id=?;', [
				$row['id']
			])->fetchAll();
			$section_list[]			=	$row;
		}
		
		$this->render('document', [
			'title'		=>	'Форум',
			'content'	=>	$this->renderTemplate('forum/index', [
				'section_list'	=>	$section_list,
				'total_unread'	=>	$this->app['db']->executeQuery('SELECT COUNT(t.id) FROM topics t LEFT JOIN topic_read r ON r.topic_id = t.id AND r.user_id=? WHERE r.topic_id IS NULL OR t.last_updated_at > r.time;', [
					$this->app['auth']->getUser()['id']
				])->fetchColumn()
			])
		]);
		
	}
	
	/**
	 *	@route("/forum/subforum")
	 */
	public function subforum() {
		
		$st	=	$this->app['db']->executeQuery('SELECT sub.* FROM subforums sub WHERE sub.id=?;', [
			(int)$this->request->query->get('id')
		]);
		if (0 == $st->rowCount())
			$this->redirect('/forum/');
		/** @var [] */
		$subforum	=	$st->fetch();
		
		$items		=	$this->app['db']->executeQuery('SELECT COUNT(t.id) FROM topics t WHERE t.subforum_id=?;', [
			$subforum['id']
		])->fetchColumn();
		$items_per_page	=	$this->app['auth']->getUser()['items_per_page'];
		$pager		=	new \Pager(
			$this->request->query->get('page'),
			$items,
			$items_per_page,
			function ($page) use ($subforum) {
				return '/forum/subforum/?id=' . $subforum['id'] . '&page=' . $page;
			}
		);
		$topic_list	=	[];
		foreach ($this->app['db']->executeQuery('SELECT t.* FROM topics t WHERE t.subforum_id=? ORDER BY t.last_updated_at DESC LIMIT ' . $pager->getOffset() . ', ' . $items_per_page . ';', [
			$subforum['id']
		])->fetchAll() as $row)
		{
			
			if (0 != $row['last_post_id']) {
				
				$st	=	$this->app['db']->executeQuery('SELECT p.* FROM posts p WHERE p.id=?;', [
					$row['last_post_id']
				]);
				if (0 != $st->rowCount()) {
					
					/** @var [] */
					$last_post			=	$st->fetch();
					$st	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
						$last_post['user_id']
					]);
					/** @var [] */
					$last_post['user']	=	0 == $st->rowCount() ? [] : $st->fetch();
					
					$row['last_post']	=	$last_post;
					
				}
				
			}
			
			$topic_list[]		=	$row;
			
		}
		
		$this->render('document', [
			'title'		=>	$subforum['title'],
			'content'	=>	$this->renderTemplate('forum/subforum', [
				'subforum'		=>	$subforum,
				'topic_list'	=>	$topic_list,
				'pager'			=>	$pager
			])
		]);
		
	}
	
	public function newTopic() {
		$st	=	$this->app['db']->executeQuery('SELECT sub.* FROM subforums sub WHERE sub.id=?;', [
			(int)$this->request->query->get('id')
		]);
		if (0 == $st->rowCount())
			$this->redirect('/forum/');
		/** @var [] */
		$subforum	=	$st->fetch();
		$errors		=	[];
		if ($this->request->isPost() &&
					0 != String::length($this->request->request->get('title')) &&
					0 != String::length($this->request->request->get('post_text'))) {
			if (2 > String::length($this->request->request->get('title')))
				$errors[]	=	'Слишком короткое название топика';
			if (2 > String::length($this->request->request->get('post_text')))
				$errors[]	=	'Слишком короткий текст сообщения';
			if (0 == count($errors)) {
				$this->app['db']->executeQuery('INSERT INTO topics
					(subforum_id, user_id, title, created_at, last_updated_at) VALUES (?, ?, ?, UNIX_TIMESTAMP(), UNIX_TIMESTAMP());', [
						$subforum['id'],
						$this->app['auth']->getUser()['id'],
						_e($this->request->request->get('title'))
					]);
				$id	=	$this->app['db']->lastInsertId();
				
				$this->app['db']->executeQuery('INSERT INTO posts
					(topic_id, user_id, text, created_at) VALUES (?, ?, ?, UNIX_TIMESTAMP());', [
					$id,
					$this->app['auth']->getUser()['id'],
					_e($this->request->request->get('post_text'))
				]);
				$post_id			=	$this->app['db']->lastInsertId();
				$this->app['db']->executeQuery('UPDATE topics
					SET total_posts=total_posts+1, last_post_id=?, last_updated_at=UNIX_TIMESTAMP() WHERE id=?;', [
					$post_id,
					$id
				]);
				
				$this->app['db']->executeQuery('UPDATE subforums
					SET total_topics=total_topics+1, total_posts=total_posts+1 WHERE id=?;', [
					$subforum['id']
				]);
				$this->app['db']->executeQuery('UPDATE users
					SET total_posts=total_posts+1 WHERE id=?;', [
					$this->app['auth']->getUser()['id']
				]);
				$this->redirect('/forum/topic/?id=' . $id);
			}
		}
		$this->render('document', [
			'title'		=>	$subforum['title'],
			'content'	=>	$this->renderTemplate('forum/newTopic', [
				'subforum'	=>	$subforum,
				'errors'	=>	$errors
			])
		]);
	}
	
	/**
	 *	@route("/forum/topic")
	 */
	public function topic() {
		
		$st	=	$this->app['db']->executeQuery('SELECT t.* FROM topics t WHERE t.id=?;', [
			(int)$this->request->query->get('id')
		]);
		if (0 == $st->rowCount())
			$this->redirect('/forum/');
		/** @var [] */
		$topic	=	$st->fetch();
		$topic['subforum']	=	$this->app['db']->executeQuery('SELECT s.* FROM subforums s WHERE s.id=?;', [
			$topic['subforum_id']
		])->fetch();
		$topic['user']	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
			$topic['user_id']
		])->fetch();
		$items		=	$this->app['db']->executeQuery('SELECT COUNT(p.id) FROM posts p WHERE p.topic_id=?;', [
			$topic['id']
		])->fetchColumn();
		$items_per_page	=	$this->app['auth']->getUser()['items_per_page'];
		$pager		=	new \Pager(
			$this->request->query->get('page'),
			$items,
			$items_per_page,
			function ($page) use ($topic) {
				return '/forum/topic/?id=' . $topic['id'] . '&page=' . $page;
			}
		);
		$post_list	=	[];
		foreach ($this->app['db']->executeQuery('SELECT p.* FROM posts p WHERE p.topic_id=? ORDER BY p.id LIMIT ' . $pager->getOffset() . ', ' . $items_per_page . ';', [
			$topic['id']
		])->fetchAll() as $row)
		{
			
			$row['user']	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
				$row['user_id']
			])->fetch();
			
			$post_list[]	=	$row;
			
		}
		
		$this->render('document', [
			'title'		=>	$topic['title'],
			'content'	=>	$this->renderTemplate('forum/topic', [
				'topic'	=>	$topic,
				'post_list'	=>	$post_list,
				'pager'		=>	$pager
			])
		]);
		
	}
	
	public function reply() {
		
		$st	=	$this->app['db']->executeQuery('SELECT t.* FROM topics t WHERE t.id=?;', [
			(int)$this->request->query->get('id')
		]);
		if (0 == $st->rowCount())
			$this->redirect('/forum/');
		/** @var [] */
		$topic	=	$st->fetch();
		$topic['subforum']	=	$this->app['db']->executeQuery('SELECT s.* FROM subforums s WHERE s.id=?;', [
			$topic['subforum_id']
		])->fetch();
		$topic['user']	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
			$topic['user_id']
		])->fetch();
		
		$post		=	null;
		$post_id	=	(int)$this->request->query->get('post_id', 0);
		if (0 != $post_id) {
			$st	=	$this->app['db']->executeQuery('SELECT p.* FROM posts p WHERE p.id=?;', [
				$post_id
			]);
			if (0 != $st->rowCount()) {
				/** @var [] */
				$post	=	$st->fetch();
				$post['user']	=	$this->app['db']->executeQuery('SELECT u.* FROM users u WHERE u.id=?;', [
					$post['user_id']
				])->fetch();
			}
		}
		
		if (1 == $topic['closed'])
			$this->redirect('/forum/topic/?id=' . $topic['id']);
		
		$errors	=	[];
		if ($this->request->isPost() &&
					$this->app['security']->isValid($this->request->request->get('csrf_token')) &&
					0 != String::length($this->request->request->get('text'))) {
			//if (1 == $topic['closed'])
			//	$errors[]	=	'Тема закрыта!';
			if (2 > String::length($this->request->request->get('text')))
				$errors[]	=	'Слишком короткое сообщение';
			if (0 == count($errors)) {
				$this->app['db']->executeQuery('INSERT INTO posts
					(topic_id, user_id, text, created_at) VALUES (?, ?, ?, UNIX_TIMESTAMP());', [
					$topic['id'],
					$this->app['auth']->getUser()['id'],
					_e($this->request->request->get('text'))
				]);
				$id			=	$this->app['db']->lastInsertId();
				$this->app['db']->executeQuery('UPDATE topics
					SET total_posts=total_posts+1, last_post_id=?, last_updated_at=UNIX_TIMESTAMP() WHERE id=?;', [
					$id,
					$topic['id']
				]);
				$this->app['db']->executeQuery('UPDATE subforums
					SET total_posts=total_posts+1 WHERE id=?;', [
					$topic['subforum_id']
				]);
				$this->app['db']->executeQuery('UPDATE users
					SET total_posts=total_posts+1 WHERE id=?;', [
					$this->app['auth']->getUser()['id']
				]);
				$this->redirect('/forum/topic/?id=' . $topic['id'] . '&page=last');
			}
		}
		
		$this->render('document', [
			'title'		=>	$topic['title'],
			'content'	=>	$this->renderTemplate('forum/reply', [
				'topic'	=>	$topic,
				'post'	=>	$post,
				'q'		=>	1 == (int)$this->request->query->get('q') ? 1 : 0,
				'errors'	=>	$errors
			])
		]);
	}
	
	public function post() {}
	
}