<?php

/**
 * Автор Олег Исаев
 * ВКонтакте: vk.com/id50416641
 * Skype: pandcar97
 */

class Kolhoz
{
	protected $path_files,
			  $curl,
			  $name_cookie,
			  $token,
			  $domen,
			  $html_farm;
	
	public function __construct()
	{
		$this->path_files = __DIR__ .'/files';
		
		if (! is_dir($this->path_files))
		{
			mkdir($this->path_files);
		}
		
		$this->curl = curl_init();
	}
	
	public function login($login, $password)
	{
		if (empty($login) || empty($password))
		{
			return false;
		}
		
		$this->set_name_cookie('cookie_'.$login.'.txt');
		
		$this->domen = file_get_contents($this->path_files.'/domen.txt');
		
		if (empty($this->domen))
		{
			$this->domen = 'kolhoz.mobi';
		}
		
		for ($i = 1; $i <= 2; $i++)
		{
			$html = $this->curl('http://'.$this->domen.'/farm');
			
			if (substr_count($html, 'HTTP/1.1 302') > 0 && substr_count($html, 'AuthorizePage') == 0)
			{
				$this->parse_domen($html);
				
				$html = $this->curl(trim($this->str_parse($html, 'Location: ', "\n")));
			}
			
			$this->html_farm = $html;
			
			if (substr_count($html, 'ruby.png') == 0)
			{
				if ($i == 1)
				{
					$this->parse_token($this->curl('http://'.$this->domen.'/'));
					
					$header = $this->curl('http://'.$this->domen.'/?-1.IFormSubmitListener-loginForm-loginForm', [
						'id'.$this->token.'_hf_0'	=> '',
						'login'						=> $login,
						'password'					=> $password,
					]);
					
					$this->parse_domen($header);
				}
				else
				{
					return false;
				}
			}
		}
		
		$this->parse_token($this->curl('http://'.$this->domen.'/settings'));
		
		return true;
	}
	
	public function get_people_online($pages = 1)
	{
		$array = [];
		
		for ($num = 0; $num <= $pages - 1; $num++)
		{
			$html = $this->curl('http://'.$this->domen.'/online?0=all&page='.$num);
			
			$list = explode('</li><li>', $this->str_parse($html, '<ul>', '</ul>'));
			
			foreach ($list as $value)
			{
				$array[] = [
					'id' => $this->str_parse($value, 'href="./user/', '"'),
					'login' => $this->str_parse($value, '"><span>', '<'),
					'status' => $this->str_parse($value, '<a class="', '"'),
				];
			}
		}
		
		return $array;
	}
	
	public function send_present($user_id, $present_id, $message)
	{
		$this->curl('http://'.$this->domen.'/presentSend?-1.IFormSubmitListener-form&0='.$user_id.'&1='.$present_id, [
			'id'.$this->token.'_hf_0'	=> '',
			'text'						=> $message,
		]);
		
		$this->next_token();
	}
	
	public function my_info()
	{
		return [
			'login' => $this->str_parse($this->html_farm, 'вошли как <span>', '<'),
			'money' => str_replace('&#039;', '', $this->str_parse($this->html_farm, 'money.png" alt="o"/> <span class="title">', '<')),
			'rubies' => str_replace('&#039;', '', $this->str_parse($this->html_farm, 'ruby.png" alt="o"/> <span class="title">', '<')),
			'level' => $this->str_parse($this->html_farm, '<span>', '</span> уровень<', true),
		];
	}
	
	protected function parse_token($html)
	{
		$this->token = $this->str_parse($html, '<input type="hidden" name="id', '_hf_0" id');
	}
	
	protected function next_token()
	{
		$this->token = dechex(hexdec($this->token) + 1);
	}
	
	protected function parse_domen($html)
	{
		$this->domen = $this->str_parse($html, 'Location: http://', '/');
		
		file_put_contents($this->path_files.'/domen.txt', $this->domen);
	}
	
	protected function str_parse($string, $ot, $do, $invers = false)
	{
		$a = explode(($invers ? $do : $ot), $string);
		if ($invers) {
			$b = explode($ot, $a['0']);
			return end($b);
		} else {
			$b = explode($do, $a['1']);
			return $b['0'];
		}
	}
	
	protected function set_name_cookie($name)
	{
		$this->name_cookie = $name;
	}
	
	protected function curl($url, $post = [])
	{
		curl_setopt($this->curl, CURLOPT_URL, $url); 
		curl_setopt($this->curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($this->curl, CURLOPT_HEADER, true);
		
		curl_setopt($this->curl, CURLOPT_HTTPHEADER, [
			'Cache-Control: max-age=0',
			'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
			'User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.81 Safari/537.36',
			'Content-Type: application/x-www-form-urlencoded',
			'Charset=utf-8',
			'Accept-Language: ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4',
		]);
		
		curl_setopt($this->curl, CURLOPT_COOKIEJAR, $this->path_files.'/'.$this->name_cookie);
		curl_setopt($this->curl, CURLOPT_COOKIEFILE, $this->path_files.'/'.$this->name_cookie);
		
		if (! empty($post))
		{
			curl_setopt($this->curl, CURLOPT_POST, true);
			curl_setopt($this->curl, CURLOPT_POSTFIELDS, http_build_query($post));
		}
		
		return curl_exec($this->curl);
	}
}
