<?php

//определяем тип: вертикальный или горизонтальный

$type = (isset($_GET['type']) && $_GET['type'] == 'g') ? 'g' : 'v';

//определяем высоту

$height = (isset($_GET['h'])) ? abs((int)$_GET['h']) : 100;

//определяем ширину

$width = (isset($_GET['w'])) ? abs((int)$_GET['w']) : 60;



//определяем цвета

$start = (isset($_GET['s']) && preg_match('#[0-9A-F]{6}#',$_GET['s'])) ? $_GET['s'] : '000000';

$end = (isset($_GET['e']) && preg_match('#[0-9A-F]{6}#',$_GET['e'])) ? $_GET['e'] : 'FFFFFF';

//определяем RGB этих цветов

$start_r= hexdec(substr($start, 0, 2));

$start_g = hexdec(substr($start, 2, 2));

$start_b = hexdec(substr($start, 4, 2));

$end_r = hexdec(substr($end, 0, 2));

$end_g = hexdec(substr($end, 2, 2));

$end_b = hexdec(substr($end, 4, 2));

//создаём картинку

$image = imagecreate($width, $height);

//определяем тип и рисуем градиент

if($type == 'g'){

for($x=0; $x<$width; $x++){

$new_r = $start_r - intval(($start_r - $end_r) / $width * $x);

$new_g = $start_g - intval(($start_g - $end_g) / $width * $x);

$new_b = $start_b - intval(($start_b - $end_b) / $width * $x);

$row_color = imagecolorresolve($image, $new_r, $new_g, $new_b);

imageline($image, $x, 0, $x, $height, $row_color);

}

}else{

for($y=0; $y<$height; $y++){

$new_r = $start_r - intval(($start_r - $end_r) / $height * $y);

$new_g = $start_g - intval(($start_g - $end_g) / $height * $y);

$new_b = $start_b - intval(($start_b - $end_b) / $height * $y);

$row_color = imagecolorresolve($image, $new_r, $new_g, $new_b);

imageline($image, 0, $y, $width, $y, $row_color);

}

}

header('Content-type: image/png');

imagepng($image);

imagedestroy($image);

//вот и всё :)

?>

Описание:
Создаём файл и туда лепим этот код.
Переходим по ссылке типа
gradient.php?type=g&w=15&h=80&s=F01935&e=08B864
Разсмотрим что здесь что значит.
type - тип градиента (горизонтальный - g, вертикальный - v - по умолчанию)
w - ширина картинки. По умолчанию 60
h - высота картинки. По умолчанию 100
s - цвет старта. По умолчанию чёрный
e - цвет конца (не того что вы подумали). По умолчанию белый.