<?php
include '../engine/includes/start.php';

$query = new Query_builder();
$query->select(array('id', 'nick', 'date_reg', 'date_last', 'group_access', 'pol'))->from('user');

$tabs = array(
    'users' => array(
        'link' => '?act=users',
        'name' => __('Пользователи'),
    ),
    'online' => array(
        'link' => '?act=online',
        'name' => __('Онлайн'),
    ),
    'administration' => array(
        'link' => '?act=administration',
        'name' => __('Администрация'),
    ),
);

switch($act)
{
    default:
        $set['title'] = __('Пользователи');
        $total = $sql->query('SELECT COUNT(*) FROM `user`')->result();
        $tabs['users']['active'] = true;
        break;

    case 'online':
        $set['title'] = __('Онлайн');
        $online_time = time()-600;
        $total = $sql->query('SELECT COUNT(*) FROM `user` WHERE `date_last` > '.$online_time)->result();
        $query->where('date_last', '>', $online_time);
        $tabs['online']['active'] = true;
        break;

    case 'administration':
        $set['title'] = __('Администрация');
        $total = $sql->query('SELECT * FROM `user` WHERE `group_access` > 1')->num_rows();
        $query->where('group_access', '>', '1');
        $tabs['administration']['active'] = true;
        break;
}

include incDir . 'head.php';

$page = new Page($total, $set['p_str']);
$query->limit($page->limit());
$sql->query($query->query);



$fenom->display('tabs.tpl', array('tabs' => $tabs));

while ($ank = $sql->fetch())
{

    echo Core::user_show($ank, array('post' => '<span class="status">'.__('Регистрация').':</span> '.Core::time($ank['date_reg']).'<br />
			<span class="status">'.__('Посл. посещение').':</span> '.Core::time($ank['date_last'])), 'new');
}

?>
    <a href="online.php" class="link"><?=__('Онлайн')?></a>
    <a href="users.php" class="link"><?=__('Пользователи')?></a>
    <a href="/" class="link"><?=__('Главная')?></a>
<?php
include incDir . 'foot.php';