<?php
    include '../engine/includes/start.php';
    if (!$user_id){
        Core::stop();
    }
    Core::add_words('user.ini', 'errors.ini');

    $set['title'] = __('Изменение данных');

    include H . 'engine/includes/head.php';

    if (isset($_POST['edit']))
    {
        if (!empty($_FILES['avatar']['tmp_name']))
        {
            $handle = new Upload($_FILES['avatar']);
            if ($handle->uploaded){
                $handle->file_new_name_body = $user_id;
                $handle->allowed = array('image/jpeg', 'image/gif', 'image/png');
                $handle->file_overwrite = true;
                $handle->image_resize = true;
                $handle->image_x = 72;
                $handle->image_ratio_y = true;
                $handle->image_convert = 'jpg';
                $handle->process(H . 'style/users/avatar/');
                if ($handle->processed){
                    Core::msg_show(__('Аватар добавлен'), 'msg');
                    $sql->query('UPDATE `user` SET `gravatar` = "no" WHERE `id` = ' . $user_id);
                }
                else{
                    Core::msg_show(__('Проблема с загрузкой: :error', array(':error' => $handle->error)));
                }
            }
        }

        $labels = array(
            'name' => 'Имя',
            'sex' => 'Пол',
            'city' => 'Город',
            'day' => 'День',
            'month' => 'Месяц',
            'year' => 'Год',
            'icq' => 'ICQ',
            'email' => 'E-mail',
            'num_phone' => 'Номер телефона',);

        $rules = $user_data = array();
        $valid = new Validator($_POST['ank'], $labels);
        $query = new Query_builder;

        if ($user['ank_name'] != Core::form('ank', 'name'))
        {
            $rules[] = array('name', 'match', "#^([A-zА-я \-]*)$#ui");
            $user_data['ank_name'] = Core::form('ank', 'name');
        }

        if ($user['pol'] != Core::form('ank', 'sex'))
        {
            $rules[] = array('sex', 'in_list', array(0, 1));
            $user_data['pol'] = Core::form('ank', 'sex');
        }

        if ($user['ank_city'] != Core::form('ank', 'city'))
        {
            $rules[] = array('city', 'match', '#^([A-zА-я \-]*)$#ui');
            $user_data['ank_city'] = Core::form('ank', 'city');
        }

        if (
            $user['ank_d_r'] != Core::form('ank', 'day') ||
            $user['ank_m_r'] != Core::form('ank', 'month') ||
            $user['ank_g_r'] != Core::form('ank', 'year'))
        {
            $rules[] = array('day, month, year', 'type', 'integer');
            $rules[] = array('day', 'in_list', range(1,31));
            $rules[] = array('month', 'in_list', range(1,12));
            $rules[] = array('year', 'in_list', range(2008, 1940, -1));
            $user_data['ank_d_r'] = Core::form('ank', 'day');
            $user_data['ank_m_r'] = Core::form('ank', 'month');
            $user_data['ank_g_r'] = Core::form('ank', 'year');
        }

        if ($user['ank_icq'] != Core::form('ank', 'icq'))
        {
            $rules[] = array('icq', 'type', 'integer');
            $rules[] = array('icq', 'length', array('min' => 4, 'max' => '9'));
            $user_data['ank_icq'] = Core::form('ank', 'icq');
        }

        if ($user['ank_mail'] != Core::form('ank', 'email'))
        {
            if ($sql->query("select count(*) from `user` where `ank_mail` = '" . Core::form('ank', 'email') . "' and `id` <> " . $user_id)->result() > 0)
            {
                Core::msg_show(__('Данный e-mail занят'));
            }
            else
            {
                $rules[] = array('email', 'email');
                $user_data['ank_mail'] = Core::form('ank', 'email');
            }
        }

        if ($user['ank_n_tel'] != Core::form('ank', 'num_phone'))
        {
             if ($sql->query("select count(*) from `user` where `ank_n_tel` = '" . Core::form('ank', 'num_phone') . "' and `id` <> " . $user_id)->result() > 0)
             {
                Core::msg_show(__('Данный номер телефона занят'));
             }
             else
             {
                $rules[] = array('num_phone', 'type', 'integer');
                $rules[] = array('num_phone', 'length', array('min' => 5, 'max' => 15));
                $user_data['ank_n_tel'] = Core::form('ank', 'num_phone');
             }
        }

        if ($user['ank_o_sebe'] != Core::form('ank', 'about'))
        {
            $user_data['ank_o_sebe'] = Core::form('ank', 'about');
        }

        if ($valid->check($rules))
        {
            $query->update('user')->set($user_data)->where('id', '=', $user_id);
            $sql->query($query->query);
            $user = Core::get_user($user_id, true);
            Cache::multi_delete('user[id=' . $user_id);

            Core::msg_show(__('Данные успешно изменены'), 'msg');
            echo '<div class="menu"><a href="anketa.php">' . __('Редактировать еще') . '</a><br />
		          <a href="user.php?id=' . $user_id . '">' . __('Посмотреть анкету') . '</a></div>';
            include H . 'engine/includes/foot.php';
        }
        else
        {
            Core::msg_show($valid->errors);
        }
    }

    if ($user['gravatar'] == 'no' && !empty($user['ank_mail']))
    {
        $gravatar_url = 'http://www.gravatar.com/avatar/' . md5(strtolower($user['ank_mail'])) . '?d=404';
        $headers = @get_headers($gravatar_url);
        if ($headers && $headers[0] != 'HTTP/1.0 404 Not Found'){
            if ($act == 'use_gravatar'){
                $sql->query('UPDATE `user` SET `gravatar` = "yes" WHERE `id` = ' . $user_id);
                $user = Core::get_user($user_id, true);
                Core::msg_show(__('Аватар добавлен'), 'msg');
                file_put_contents(H . 'style/users/avatar/' . $user_id . '.jpg',
                                  file_get_contents('http://www.gravatar.com/avatar/' . md5(strtolower($user['ank_mail'])) . '?s=72&amp;d=identicon'));
            }
            else{
                echo '<a href="?act=use_gravatar">' . __('У Вас есть изображение на Gravatar, использовать его как аватар') . '?</a><br /> <img src="http://www.gravatar.com/avatar/' . md5(strtolower($user['ank_mail'])) . '?s=100&amp;d=identicon" alt="" />';
            }
        }
    }
    ?>
    <form method="post" enctype="multipart/form-data" name="ank">

        <?= __('Аватар') ?>:<br />
        <?= Core::user_avatar() ?><br />
        <input type="file" name="avatar"/><br />

        <?= __('Имя') ?>:<br />
        <input type="text" name="ank[name]" value="<?= $user['ank_name'] ?>"/><br />

        <?= __('Пол') ?>:<br />
        <select name="ank[sex]">
            <option value="1"><?= __('Мужской') ?></option>
            <option value="0" <?= $user['pol'] == 0 ? 'selected="selected"' : '' ?>><?= __('Женский') ?></option>
        </select><br/>

        <?= __('Город') ?>:<br />
        <input type="text" name="ank[city]" value="<?= $user['ank_city'] ?>"/><br />

        <?= __('Дата рождения') ?>
        <small>(<?= __('день - месяц - год') ?>)</small>:<br />
        <input type="text" name="ank[day]" size="1" value="<?= $user['ank_d_r'] ?>"/>&nbsp;.&nbsp;
        <input type="text" name="ank[month]" size="1" value="<?= $user['ank_m_r'] ?>"/>&nbsp;.&nbsp;
        <input type="text" name="ank[year]" size="1" value="<?= $user['ank_g_r'] ?>"/><br />

        Icq:<br />
        <input type="text" name="ank[icq]" value="<?= $user['ank_icq'] ?>"/><br />

        <?= __('E-mail') ?>:<br />
        <input type="text" name="ank[email]" value="<?= $user['ank_mail'] ?>"/><br />

        <?= __('Номер телефона') ?>:<br />
        <input type="text" name="ank[num_phone]" value="<?= $user['ank_n_tel'] ?>"/><br />

        <?= __('О себе') ?>:<br />
        <textarea name="ank[about]"><?= $user['ank_o_sebe'] ?></textarea><br />

        <input type="submit" name="edit" value="<?= __('Изменение данных') ?>"/>
    </form>

    <a href="user.php" class="link"><?= __('Анкета') ?></a>
    <a href="menu.php" class="link"><?= __('Кабинет') ?></a>
    <a href="/" class="link"><?= __('Главная') ?></a>
    <?
    include H . 'engine/includes/foot.php';