<?php
    $start = microtime(true);
    $btn_clickable = true;

    define('H', $_SERVER['DOCUMENT_ROOT'] . '/');
    if (file_exists(H . 'engine/files/data/settings.ini')){
        // exit('Движок уже установлен');
    }


    function show_error($err)
    {
        if (is_array($err)){
            foreach ($err as $value){
                echo '<div class="err">' . $value . '</div>';
            }
        }
        else{
            echo '<div class="err">' . $err . '</div>';
        }
    }

    function save_settings($set)
    {
        include_once H . 'engine/classes/Ini.php';
        $ini = new ini(H . 'engine/files/data/settings.ini');
        foreach ($set as $key => $value){
            $ini->write($key, '"' . $value . '"');
        }

        return $ini->updateFile();
    }

    // рекурсивное удаление папки
    function delete_dir($dir)
    {
        if (is_dir($dir)){
            $od = opendir($dir);
            while ($rd = readdir($od)) {
                if ($rd == '.' || $rd == '..'){
                    continue;
                }
                if (is_dir("$dir/$rd")){
                    @chmod("$dir/$rd", 0777);
                    delete_dir("$dir/$rd");
                }
                else{
                    @chmod("$dir/$rd", 0777);
                    @unlink("$dir/$rd");
                }
            }
            closedir($od);
            @chmod("$dir", 0777);

            return @rmdir("$dir");
        }
        else{
            @chmod("$dir", 0777);
            @unlink("$dir");
        }
    }

    ob_start();
    session_start();
    header("Content-type: text/html");
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru">
<head>
    <title>Установка</title>
    <link rel="stylesheet" href="/style/themes/default/style.css" type="text/css"/>
    <link rel="icon" type="image/png" href="/favicon.ico"/>
</head>
<body>
<div class="title">
    Установка SecWind
</div>
<div class="news">
<?php

    if (!isset($_SESSION['install_step']) || $_SESSION['install_step'] < 0 && $_SESSION['install_step'] > 7){
        $_SESSION['install_step'] = 0;
    }
//if (isset($_GET['step']))
    //$_SESSION['install_step']++;
    $_SESSION['install_step'] = isset($_GET['step']) ? ($_GET['step'] > 7 ? 7 : $_GET['step']) :$_SESSION['install_step'];

    switch ($_SESSION['install_step'])
    {

    case 0:

        ?>
        <img src="/style/sw.png" style="float:left;padding-right: 5px;"/>
            Уставнока SecWind<br/>
        <br/>
        Автор: Patsifist <br/>
        <hr/>
        Спасибо за модули:
        <ul>
            <li>Screamer - Библиотека</li>
            <li>FlySelf - Загруз центр</li>
            <li>seg0ro - Форум</li>
            <li>FoXxs - Дневники</li>
        </ul>
        <hr/>
        Спасибо за переводы:
        <ul>
            <li>no0k - Украинский, английский</li>
            <li>Bek-Z - Казахский</li>
        </ul>
        <?php
        break;

    case 1:
        $last_version = @json_decode(file_get_contents('http://secwind.ru/?act=get_last_version'), true);
        $my_version = parse_ini_file(H . 'engine/files/data/for_settings.ini');

        if (empty($last_version) || (function_exists('json_last_error') && json_last_error())){
            echo 'Возможно вы не используете последнюю версию<br />';
        }
        else{
            echo (version_compare($last_version['last_version'],
                                  $my_version['version']) == 0 ? 'У вас установлена последняя версия' : 'Последняя: <a href="' . $last_version['link_update'] . '">' . $last_version['last_version'] . ' ' . $last_version['status'] . '</a>') . '<br />
				Дата выхода: ' . date('H:i, j F', $last_version['time_release']) . '<br />
				Список изменений в версии ' . $last_version['last_version'] . ': <br /> ' . nl2br($last_version['changelog']) . '<hr />';
        }
        echo file_get_contents(H . 'engine/files/data/agreement.txt');
        break;

    case 2:
        include H . 'engine/includes/testing.php';
        include H . 'engine/includes/chmod_test.php';

        if (isset($err)){
            show_error($err);
            $btn_clickable = false;
        }
        break;

    case 3:
        $btn_clickable = false;

        if (isset($_POST['host'], $_POST['user'], $_POST['pass'], $_POST['db'])){
            $db = @mysqli_connect($_POST['host'], $_POST['user'], $_POST['pass'], $_POST['db']);
            if (!$db){
                $err = 'Невозможно подключиться к серверу ' . htmlspecialchars(mysqli_connect_error());
            }
            else{
                $_SESSION['db'] = $_POST['db'];
                $_SESSION['host'] = $_POST['host'];
                $_SESSION['user'] = $_POST['user'];
                $_SESSION['pass'] = $_POST['pass'];

                mysqli_query($db, 'SET names utf8');
                mysqli_multi_query($db, file_get_contents(H . 'engine/files/data/table.sql'));
                echo '<div class="msg">Подключение к базе данных успешно выполнено</div>';
                $btn_clickable = true;
            }
        }

        if (isset($err)){
            show_error($err);
        }


        ?>
        <form method="post" <?= $btn_clickable ? 'style="display:none"' : '' ?>>
            Хост:<br/>
            <input name="host"
                   value="<?= $_SERVER['REMOTE_ADDR'] == '127.0.0.1' ? 'localhost' : $_SERVER['SERVER_NAME'] ?>"
                   type="text"/><br/>
            Пользователь:<br/>
            <input name="user" value="root" type="text"/><br/>
            Пароль:<br/>
            <input name="pass" value="" type="text"/><br/>
            Имя базы:<br/>
            <input name="db" value="<?= $_SERVER['SERVER_NAME'] ?>" type="text"/><br/>
            <input type="submit" value="Соединить с базой"/>
        </form>
        <?php
        break;

    case 4:
    $btn_clickable = false;
    $db = mysqli_connect($_SESSION['host'], $_SESSION['user'], $_SESSION['pass'], $_SESSION['db']);
    mysqli_query($db, 'SET names utf8');
    if (isset($_POST['reg']))
    {
    if (empty($_POST['nick'])){
        $err[] = 'Введите ник';
    }
    elseif (!preg_match("#^([A-zА-я0-9\-\_\ ])+$#ui", $_POST['nick'])){
        $err[] = 'В нике присутствуют запрещенные символы';
    }
    else{
        $nickLen = mb_strlen($_POST['nick']);
        if ($nickLen < 3){
            $err[] = 'Ник короче 3-х символов';
        }
        elseif ($nickLen > 16){
            $err[] = 'Ник длиннее 16-ти символов';
        }
        elseif (@mysqli_num_rows(mysqli_query($db,
                                              "SELECT COUNT(*) FROM `user` WHERE `nick` = '" . mysqli_real_escape_string($db,
                                                                                                                         $_POST['nick']) . "' LIMIT 1")) > 1
        ){
            $err[] = 'Выбранный ник уже занят другим пользователем';
        }
        else{
            $nick = $_POST['nick'];
        }
    }

    if (empty($_POST['password'])){
        $err[] = 'Введите пароль';
    }
    else{
        $pass_Len = mb_strlen($_POST['password']);
        if ($pass_Len < 6){
            $err[] = 'Пароль короче 6-ти символов';
        }
        elseif ($pass_Len > 16){
            $err[] = 'Пароль длиннее 16-ти символов';
        }
        elseif (empty($_POST['password_retry'])){
            $err[] = 'Введите подтверждение пароля';
        }
        elseif ($_POST['password'] !== $_POST['password_retry']){
            $err[] = 'Пароли не совпадают';
        }
        else{
            $password = $_POST['password'];
        }
    }

    $pol = $_POST['pol'] == 0 ? 0 : 1;

    if (!isset($err))
    {
    $status = mysqli_fetch_assoc(mysqli_query($db, 'SHOW TABLE STATUS LIKE "user"'));
    $password = md5($status['Auto_increment'] . $password);
    mysqli_query($db, "
			    INSERT INTO `user`
				(`nick`, `pass`, `date_reg`, `date_aut`, `date_last`, `pol`, `group_access`, `balls`) VALUES
				('" . $nick . "', '" . $password . "', '" . time() . "', '" . time() . "', '" . time() . "', '" . $pol . "', '10', '82366622244044')");
    echo mysqli_error($db);
    $user = mysqli_fetch_assoc(mysqli_query($db, "SELECT `id` FROM `user` WHERE `nick` = '$nick' LIMIT 1"));

    $_SESSION['user_id'] = $user['id'];
    setcookie('user_id', $user['id'], time() + 60 * 60 * 24 * 365, '/');
    setcookie('pass', $password, time() + 60 * 60 * 24 * 365, '/');

    echo '<div class="msg">Регистрация администратора прошла успешно</div>';

    if (isset($msg)){
        echo '<div class="msg">' . $value . '</div>';
    }
?>
<h3>После установки обязательно удалите папку /install/<h3/>
    <?
        $btn_clickable = true;
        }

        if (isset($err)){
            foreach ($err as $err){
                echo '<div class="err">' . $err . '</div>';
            }
            ?>
            <form>
                <input value="Повторить" type="submit"/>
            </form>
        <?
        }
        }
        else{
            ?>
            <form method='post'>
                Логин (3-16 символов):<br/>
                <input type='text' name='nick' value="admin" maxlength="16"/><br/>
                Пароль (6-16 символов):<br/>
                <input type='password' name='password' maxlength='16'/><br/>
                Подтверждение пароля:<br/>
                <input type='password' name='password_retry' maxlength='16'/><br/>
                Ваш пол:<br/>
                <select name='pol'>
                    <option value='1' selected='selected'>Мужской</option>
                    <option value='0'>Женский</option>
                </select><br/>
                * Все поля обязательны к заполнению<br/>
                <input type='submit' name='reg' value='Регистрация'/><br/>
            </form>
        <?
        }
        break;

        case 5:
            

            if (isset($_POST['ok'])){
                if (empty($_POST['modules'])){
                    show_error('Не выбраны модули для установки');
                }
                else{
                    $_SESSION['modules'] = $_POST['modules'];
                    $_SESSION['modules_list'] = count($_POST['modules']);
                    $_SESSION['modules_installed'] = 0;
                    echo '<div class="msg">Нажмите далее для установки модулей</div>';
                }
            }
            else{
				save_settings(array_merge(
                              parse_ini_file(H . 'engine/files/data/for_settings.ini'),
                              array(
                                  'title' => ucfirst($_SERVER['HTTP_HOST']),
                                  'mysql_host' => $_SESSION['host'],
                                  'mysql_user' => $_SESSION['user'],
                                  'mysql_pass' => $_SESSION['pass'],
                                  'mysql_db_name' => $_SESSION['db'])));

            

            $config = array('date_create' => time(), 'author_info' => array('name' => 'Patsifist', 'icq' => 1314191, 'email' => 'Tadochi@spaces.ru'), 'support' => 'SecWind.ru');

            file_put_contents(H . 'engine/files/data/secwind.db', serialize($config));
            unlink(H . 'engine/files/data/for_settings.ini');
            unlink(H . 'engine/files/data/table.sql');
                $modules = opendir(H . 'engine/files/modules/configs/');
                $btn_clickable = false;
                echo '<div class="menu_razd">Выберите модуль, который хотели бы установить</div><form method="post">';

                while ($modul = readdir($modules)) {
                    if ($modul == '.' || $modul == '..'){
                        continue;
                    }

                    $name = pathinfo($modul, PATHINFO_FILENAME);
                    $module = array_map('htmlspecialchars',
                                        parse_ini_file(H . 'engine/files/modules/configs/' . $name . '.app'));
                    echo '
				<div class="link"><label>
				<input type="checkbox" name="modules[]" value="' . $name . '"/> ' . (!empty($module['module_runame']) ? $module['module_runame'] : $module['module_name']) . '' . (!empty($module['module_version']) ? '<span class="status" style="float:right;font-size:smaller">' . $module['module_version'] . '</span>' : '') . (!empty($module['module_desc']) ? '<br />' . nl2br($module['module_desc']) : '') . '</label></div>';
                }
                echo '<input type="submit" name="ok" value="Выбрать"/></form>';
            }
            break;

        case 6:
            $btn_clickable = false;
            if (isset($_POST['answer'])){
                if ($_POST['answer'] == 'Принять'){
                    $module_file = $_POST['module'];
                    $module = array_map('htmlspecialchars',
                                        parse_ini_file(H . 'engine/files/modules/configs/' . $module_file . '.app'));
                    $db = mysqli_connect($_SESSION['host'], $_SESSION['user'], $_SESSION['pass'], $_SESSION['db']);
                    mysqli_query($db, 'SET names utf8');


                    $dir_install = empty($module['dir_install']) ? H : H . $module['dir_install'] . '/';
                    $dir_pre_install = empty($module['dir_install']) ? H . 'engine/files/tmp/' : H . 'engine/files/tmp/' . $module['dir_install'] . '/';
                    $ftp_dir_ins = str_replace(H, '', $dir_install);
                    $ftp_dir_pre = str_replace(H, '', $dir_pre_install);


                    if (!is_dir($dir_install) && !mkdir($dir_install))
                    {
                        show_error('Возникла проблема с папкой для установки');
                    }
                    else
                    {
                        include_once H . 'engine/classes/Pclzip.php';
                        $zip = new Pclzip(H . 'engine/files/modules/archives/' .$module_file . '.zip');
						
						foreach ($zip->listContent() as $item)
						{
							if ($item['folder'] == 0)
							{
								continue;
							}
							if (!is_dir(H . $item['filename']))
							mkdir(H . $item['filename'], 0777);// var_dump($item);
						}
						
                        $zip->extract(PCLZIP_OPT_SUBSTITUE_FILE, H);


                        show_error('Модуль "'.$module['module_name'].'" установлен');

                        if (!empty($module['file_sql'])){
                            mysqli_multi_query($db, file_get_contents($dir_install . $module['file_sql']));
                            show_error('Сделаны запросы из файла ' . $module['file_sql']);
                            unlink($dir_install . $module['file_sql']);
                        }

                        if (!empty($module['dir_chmod'])){
                            $dirs = explode(' ', $module['dir_chmod']);
                            foreach ($dirs as $dir){
                                chmod(H . $dir, 0777);
                            }
                            show_error('Выставлены права доступа 777 на необходимые папки');
                        }

                        mysqli_query($db, "INSERT INTO `modules` SET
					`name` = '" . mysqli_real_escape_string($db, $module['module_name']) . "',
					`ru_name` = '" . (!empty($module['module_runame']) ? mysqli_real_escape_string($db, $module['module_runame']) : '') . "',
					`desc` = '" . (!empty($module['module_desc']) ? mysqli_real_escape_string($db, $module['module_desc']) : '') . "',
					`version` = '" . (!empty($module['module_version']) && is_numeric($module['module_version']) ? $module['module_version'] : '') . "',
					`uninstaller` = '" . (!empty($module['file_uninstaller']) ? mysqli_real_escape_string($db, $module['file_uninstaller']) : '') . "',
					`author_name` = '" . mysqli_real_escape_string($db, $module['author_name']) . "',
					`author_e-mail` = '" . (!empty($module['author_e-mail']) ?mysqli_real_escape_string($db, $module['author_e-mail']) : '') . "',
					`author_icq` = '" . (!empty($module['author_icq']) ? intval($module['author_icq']) : '') . "',
					`author_wmid` = '" . (!empty($module['author_wmid']) ? intval($module['author_wmid']) : '') . "'");


                        //unlink(H . 'engine/files/modules/configs/' .$module_file . '.app');
                        //unlink(H . 'engine/files/modules/archives/' . $module_file . '.zip');
                        /*if (file_exists(H . 'style/icons/modules/' .$module['module_name'] . '.png'))
                        {
                            Rename(H . 'style/icons/modules/' . $module['module_name'] . '.png',
                                   H . 'style/icons/modules/' . $module['module_name'] . '.png');
                        }*/
                    }
                }
                if (!$_SESSION['modules'])
                {
                    $btn_clickable = true;
                    echo '<div class="menu_razd">Установка закончена, нажмите "Далее" для завершения</div>';
                }
                else
                {
                    echo '<a class="link" href="?">Установить следующий модуль</a>';
                }
            }
            else{
                if (!empty($_SESSION['modules']))
                {
                    $module_file = array_shift($_SESSION['modules']);
                    $module = array_map('htmlspecialchars', parse_ini_file(H . 'engine/files/modules/configs/' . $module_file . '.app'));
                    echo '<div class="post">
                            <img src="/style/icons/modules/' . (file_exists(H . 'style/icons/modules/' . $module['module_name'] . '.png') ? $module['module_name'] : '0') . '.png"/> ' . (!empty($module['module_runame']) ? $module['module_runame'] . ' (' . $module['module_name'] . ')' : $module['module_name']) . '<br />
                            <span class="status">Автор:</span> ' . $module['author_name'] . '<br />' . (!empty($module['module_version']) ? '<span class="status">Версия:</span> ' . $module['module_version'] . '<br />' : '') . (!empty($module['module_desc']) ? nl2br($module['module_desc']) . '<br />' : '') . '<textarea>' . (!empty($module['agreement']) ? $module['agreement'] : 'Устанавливая модуль "' . $module['module_name'] . '", Вы принимаете условия использования модуля.') . '</textarea><br />' . '<form method="post">
                                <input type="hidden" name="module" value="' . $module_file . '"/>
                                <input type="submit" name="answer" value="Отказаться"/>
                                 <input type="submit" name="answer" value="Принять"/>
                            </form>
                            </div>';
                }
                else
                {
                    $btn_clickable = true;
                    show_error('Этап пропущен. Вы не выбрали ни одного модуля, Вы можете установить модули в люое время, через админку');
                }
            }
            break;

            case 7:
                mkdir(H.'engine/files/tmp/', 0777);
                mkdir(H.'engine/files/backup/files/',0777);
                mkdir(H.'engine/files/backup/mysql/',0777);
                mkdir(H.'engine/files/users/cache/',0777);
				if ($_SERVER['SERVER_ADDR'] != '127.0.0.1'){
                delete_dir(H . 'install/');
				}
                header('Location: /');
                exit;
            break;
        }

    ?>
    <form>
        <input name='step' value='<?= $_SESSION['install_step'] + 1 ?>' type='hidden'/>
        <input value='Далее' type='submit'<?= !$btn_clickable ? ' style="display:none"' : '' ?>/>
    </form>
</div>
<!-- Div "main_menu" -->
<div class='foot'>
    Генерация: <?= round(microtime(1) - $start, 4) ?> сек<br/>
</div>
</body>
</html>