<?php

    /**
     * @author Patsifist
     */


    /**
     * @const START для измерения генерации
     * @const H объявляем корень
     */

    define('START', microtime(1));
    define('H', $_SERVER['DOCUMENT_ROOT'] . '/');
    define('CPU', memory_get_usage());
    define('incDir', H . 'engine/includes/');
    define('tmpDir', H . 'engine/files/tmp/');
    define('MAIN', $_SERVER['PHP_SELF'] == '/index.php');


    if (is_file(H . 'engine/files/data/settings.ini')){
        $set = parse_ini_file(H . 'engine/files/data/settings.ini');
    }
    else{
        exit('<a href="/install/">Установить</a>');
    }


    if (is_file(H . 'engine/files/data/flood_config.swi')){
        $flood = new FloodBlocker;
        if (!$flood->CheckFlood()){
            die('Слишком много запросов. Попробуйте позже');
        }
        unset($flood);
    }


    /**
     * @var int $time время в timestamp
     */

    $time = $_SERVER['REQUEST_TIME'];


    /**
     * @var $id , $act чтобы 100 раз не проверять
     */

    $id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    $act = isset($_GET['act']) ? $_GET['act'] : false;
    $cur_page = isset($_GET['page']) ? (int) $_GET['page'] : 0;
    $sql = include H . 'engine/classes/My_sqli.php';


    /**
     * Open Graph. Подробнее тут http://help.yandex.ru/webmaster/video/open-graph-markup.xml
     */

    $meta_og = array(
        'site_name' => 'SecWind',
        'url' => htmlspecialchars('http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']),
        'image' => 'http://' . $_SERVER['SERVER_NAME'] . '/style/sw.png',
        'locale' => 'ru_RU',
        'title' => $set['title'],
        'description' => $set['meta_description']);


    session_name('Secwind');
    session_start();

    //if (is_callable('ini_set')) {
    @set_time_limit(10);
    @ini_set('date.timezone', 'Europe/Moscow');
    @ini_set('html_errors', 1);
    mb_internal_encoding('UTF-8');

    set_error_handler('error_catch');

    /**
     * @function error_catch
     * Перехват ошибок
     * @param $errno
     * @param $errstr
     * @param $errfile
     * @param $errline
     * @param $desc
     * @param string $type
     * @return null
     */

    function error_catch($errno, $errstr, $errfile, $errline, $desc, $type = 'php')
    {
        if (0 == error_reporting()){
            return;
        }

        global $sql, $creator;

        if ($type == 'php'){
            $desc = $errstr . ' | Файл ' . $errfile . '  | Линия - ' . $errline;
        }

        if ($creator && $type == 'php'){
            echo $desc . '<br />';
        }

        $sql->query("
            INSERT INTO `errors`
            (`user` , `time`, `user_agent`, `ip`, `desc`, `type`, `url`) VALUES
            ('" . Core::$user_id . "', '" . time() . "', '" . my_esc($_SERVER['HTTP_USER_AGENT'],
                                                                     true) . "', '" . my_esc($_SERVER['REMOTE_ADDR'],
                                                                                             true) . "', '" . my_esc($desc) . "', '" . $type . "', '" . my_esc($_SERVER['REQUEST_URI'],
                                                                                                                                                               true) . "');");
    }

    spl_autoload_register('autoloader');

    function autoloader($file)
    {
        if (is_file(H . 'engine/classes/' . $file . '.php')){
            include H . 'engine/classes/' . $file . '.php';
        }
    }




/**
     * @class Core
     * эдакий контейнер функций
     */
    Class Core
    {
        static $user_id = 0;
        static $language, $lang_words;
        static $set;

        function __construct($set)
        {
            self::$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0; // self::$user_id = isset($_SESSION['user_id']);
            self::$set = $set;
            Core::set_lang('ru');
        }

        static function set_lang($lang)
        {
            self::$language = $lang;
            self::$lang_words = parse_ini_file(H . 'engine/files/languages/' . self::$language . '/words.ini');
        }

        static function add_words()
        {
            $files = func_get_args();
            foreach ($files as $file){
                if (is_file(H . 'engine/files/languages/' . Core::$language . '/' . $file)){
                    self::$lang_words = array_merge(self::$lang_words,
                                                    parse_ini_file(H . 'engine/files/languages/' . Core::$language . '/' . $file));
                }
                elseif (is_file($file)){
                    self::$lang_words = array_merge(self::$lang_words, parse_ini_file($file));
                }
            }
        }

        /**
         * Кеширование данных пользователей
         * @param integer $id id юзера, данные которого нужно получить
         * @param bool $update если указать true, данные обновятся
         * @return array
         */

        static function get_user($id, $update = false)
        {
            if ($update || !file_exists(H . 'engine/files/users/cache/' . $id . '.db') || filemtime(H . 'engine/files/users/cache/' . $id . '.db') > ($_SERVER['REQUEST_TIME'] + 3600)
            ){
                global $sql;
                $user = $sql->query('select * from `user` where `id` = "' . $id . '" limit 1 ')->fetch();
				$user['new_messages'] = 0;
				
                if (!$user){
                    return array('id' => 0, 'nick' => 'Гость', 'pol' => 1);
                }

                file_put_contents(H . 'engine/files/users/cache/' . $id . '.db', serialize($user));
                unset($sql, $user);
            }
			
            return unserialize(file_get_contents(H . 'engine/files/users/cache/' . $id . '.db'));
        }


        /**
         * Перенаправление
         * @function stop
         * @param string $page
         * @return void
         */

        static function stop($page = '/')
        {
            header('location: ' . $page);
            exit;
        }


        /**
         * Сохранение настроек
         * @function save_settings
         * @param array $set Массив для сохранения
         * @param string $file Файл для сохранения
         * @return bool Возращает true, если сохранение успешно
         */

        static function save_settings($set, $file = 'engine/files/data/settings.ini')
        {
            $ini = new Ini(H . $file);
            foreach ($set as $key => $value){
                $ini->write($key, '"' . $value . '"');
            }

            return $ini->updateFile();
        }

        /**
         * Вывод даты
         * @function time
         * @param integer $time
         * @return string Возвращает дату с форматированием
         */

        static function time($time)
        {
            $year = date('Y', $time);
            return date('H:i, j ', $time) .  __(date('F', $time)).($year != date('Y') ? __(', :year года', array(':year' => $year)) : null);
        }

        /**
         * Подключение файлов
         * @function get
         * @param mixed $file принимает массив или строку
         * @param string $path папка файла
         */

        static function get($file, $path = 'includes')
        {
            if (is_array($file))
            {
                foreach ($file as $file_id)
                {
                    self::get($file_id, $path);
                }
            }
            elseif (file_exists(H . 'engine/' . $path . '/' . $file . '.php'))
            {
                include_once H . 'engine/' . $path . '/' . $file . '.php';
            }
            //else die('file engine/'.$path.'/'.$file.'.php not found');
        }


        /**
         * Вывод сообщений. Вместо msg() и err() из Dcms
         * @function msg_show
         * @param mixed $msg выводимое сообщение. Может быть массивом или строкой
         * @param string $div класс div'а.
         * @return string озвращает строку в нужном <div>
         */

        static function msg_show($msg, $div = 'error')
        {
            global $fenom;
            $fenom->display('msg_show.tpl', array('msg' => $msg, 'type' => $div));
        }


        /**
         * Вывод пользователя
         * @param array $user массив юзера
         * @param array $data $data['post'] текст который выводится снизу. $data['status'] текст который выводится рядом с ником. $data['is_time'] должна true, если $data['status'] - timestamp
         * @param string $view стиль для отображения. old - вывод пользователя с минимальным количеством элементов, new - вывод с аватаркой
         * @return string Вывод данных юзера
         */

        static function user_show($user, $data = array(), $view = 'mini')
        {
            $vars = array(
                'user' => $user,
                'icon' => self::user_icon($user, 'path'),
                'avatar' => self::user_avatar($user['id'], 'path'),
                'status' => (isset($data['status']) ? (is_numeric($data['status']) == 10 ? Core::time($data['status']) : $data['status']) : false),
                'post' => (!empty($data['post']) ? $data['post'] : false),
            );
            global $fenom;
            $fenom->display('user_show_'.$view.'.tpl', $vars);
        }


        // вывод иконки юзера

        static function user_icon($user, $return = 'html')
        {
            $pol = $user['pol'] == 1 ? 'man' : 'woman';
            $online = $user['date_last'] > ($_SERVER['REQUEST_TIME'] - 300) ? 'on' : 'off';

            if ($online == 'off'){
                return $return == 'html' ?
                    '<img src="/style/users/icons/' . $pol . '_' . $online . '.png" alt=""/>':
                    '/style/users/icons/' . $pol . '_' . $online . '.png';
            }
            else{
                //$user_id = isset($_SESSION['user_id']) ? $user['id'] : 0;
                $group = 'user';
                if ($user['group_access'] > 9){
                    $group = 'creator';
                }
                elseif ($user['group_access'] > 2){
                    $group = 'admin';
                }
                elseif ($user['group_access'] > 1){
                    $group = 'moder';
                }

                return $return == 'html' ?
                    '<img src="/style/users/icons/' . $group . '_' . $pol . '_' . $online . '.png" alt=""/>' :
                    '/style/users/icons/'.$group . '_' . $pol . '_' . $online . '.png';
            }
        }

        // вывод аватара юзера

        static function user_avatar($ava_id = 0, $return = 'image')
        {
            if (!$ava_id){
                $ava_id = Core::$user_id;
            }
            $id = file_exists(H . 'style/users/avatar/' . $ava_id . '.jpg') ? $ava_id : 0;

            return $return == 'image' ? '<img src="/style/users/avatar/' . $id . '.jpg"/>' : '/style/users/avatar/' . $id . '.jpg';
        }


        // Получение данных о SW

        static function Secwind($key = false)
        {
            $inf = unserialize(file_get_contents(H . 'engine/files/data/secwind.db'));

            return $key ? $inf[$key] : var_export($inf);
        }


        /**
         * Получение фильтрированных данных из $_GET
         * @param mixed $key
         * @return string возвращает фильтрированные данные из $_GET
         */

        static function Request($key)
        {
            return isset($_GET[$key]) ? is_array($_GET[$key]) ? $_GET[$key] : my_esc($_GET[$key], true) : false;
        }

        static function form($key, $key2 = false)
        {
            if (!$key2)
            {
                return isset($_POST[$key]) ? is_array($_POST[$key]) ? $_POST[$key] : my_esc($_POST[$key], true) : false;
            }
            else
            {
                return isset($_POST[$key][$key2]) ? my_esc($_POST[$key][$key2], true) : false;
            }
        }
    }


    /**
     * функция для фильтрации строк
     * @function my_esc
     * @param string $str строка для фильтрации
     * @param bool $html
     * @todo удалить!
     * @return string возвращает экраннированную строку
     */

    function my_esc($str, $html = false)
    {
        global $sql;
        if ($html){
            $str = htmlspecialchars($str);
        }

        return $sql->esc($str);
    }


    /**
     * @param string $str Строка для перевода
     * @param array $data Неизменяемые данные
     * @param bool|string $to_lang Перевод на данный язык
     * @return string Переведенная строка
     */

    function __($str, $data = array(), $to_lang = false)
    {
        if ($to_lang && is_file(H . 'engine/files/languages/' . $to_lang . '/words.ini')){
            $lang_words = parse_ini_file(H . 'engine/files/languages/' . $to_lang . '/words.ini');
            $tr_str = isset($lang_words[$str]) ? $lang_words[$str] : $str;
        }
        else{
            $tr_str = isset(Core::$lang_words[$str]) ? Core::$lang_words[$str] : $str;//.'|'.var_dump($str);
        }

        return str_replace(array_keys($data), array_values($data), $tr_str);
    }



    //etcookie('language', 'en', ($time + 12212)); //@todo

    /**
     * Авторизация
     */

    if (isset($_SESSION['user_id'])){
        $user = Core::get_user($_SESSION['user_id']);
    }
    elseif (isset($_COOKIE['user_id'], $_COOKIE['pass']) && $sql->query("SELECT COUNT(*) FROM `user` WHERE `id` = " . intval($_COOKIE['user_id']) . " AND `pass` = '" . my_esc($_COOKIE['pass']) . "' LIMIT 1")->result() == 1){
        $_SESSION['user_authed'] = 'COOKIE';
        $user = Core::get_user($_COOKIE['user_id']);
        $sql->query('select `file` from `module_services` where `use_in` = "auth"');
        while($file = $sql->result($query))
        {
            include_once H . $file;
        }

    }

    if (isset($user)){
        $user_id = $_SESSION['user_id'] = $user['id'];
		if (empty($_SESSION['new_messages_time']) || $_SESSION['new_messages_time'] > $time + 20)
			{
				$_SESSION['new_messages_time'] = $time + 20;
				$user['new_messages'] = $_SESSION['new_messages'] = $sql->query('SELECT sum(`unread`) FROM `mail_contacts` WHERE `user_id` = ' . $user_id)->result();
				if ($_SERVER['PHP_SELF'] != '/pages/ban.php' && $sql->query('SELECT COUNT(*) FROM `ban` WHERE `user_id` = ' . $user_id . ' AND `time` > ' . $time . ' LIMIT 1')->result() == 1){
					Core::stop('/pages/ban.php');
				}
			}
			else
			{
				$user['new_messages'] = $_SESSION['new_messages'];
			}
        

        if (mt_rand(1, 2) == 1){
            $sql->query('UPDATE `user` SET `date_last` = ' . $time . ' WHERE `id` = ' . $user['id'] . ' LIMIT 1');
        }
    }
    else{
        $user_id = 0;
    }


    /**
     * @var $user_id (bool) вернет true если юзер авторизован
     * @var $moder (bool) вернет true для модератора
     * @var $admin (bool) вернет true для админа
     * @var $creator (bool) вернет true для создателя
     * @var $author (bool) вернет true если юзер - автор
     */

    $user_id = isset($_SESSION['user_id']) ? $user['id'] : 0;
    $moder = $user_id && $user['group_access'] > 1;
    $admin = $user_id && $user['group_access'] > 2;
    $creator = $user_id && $user['group_access'] > 9;
    $show_theme = $set['theme'] = isset($_COOKIE['set_theme']) ? $_COOKIE['set_theme'] :  (!empty($user['set_them']) ? $user['set_them'] : $set['theme']);
    //$author = $user_id == $id;


    if ($set['filtr_get']){
        array_walk_recursive($_GET, create_function('&$value, $key', '$value = my_esc($value);'));
    }

    if ($set['filtr_post']){
        array_walk_recursive($_POST, create_function('&$value, $key', '$value = my_esc($value);'));
    }

    if ($set['antixss']){

        /*
         * Защита/предупреждение XSS-атак
         */

        if (isset($_SERVER['HTTP_REFERER'])){
            $ref = parse_url($_SERVER['HTTP_REFERER']);
            if (!substr_count($ref['host'], $_SERVER['HTTP_HOST'])){
                if ($_POST){
                    die('<b>Achtung! XSS attack!</b>');
                }
                if ($_GET){
                    die('<b>Achtung! XSS attack?></b><br />Подтвердите переход: <a href="' . htmlspecialchars($_SERVER['REQUEST_URI']) . '">' . htmlspecialchars($_SERVER['REQUEST_URI']) . '</a>');
                }
            }
        }

        array_walk_recursive($_GET, create_function('&$value, $key', '$value = htmlspecialchars($value);'));
        array_walk_recursive($_POST, create_function('&$value, $key', '$value = htmlspecialchars($value);'));
    }


    /*
	* SecWind?
	*/

    if (isset($_GET['you_secwind?'])){
        exit(Core::Secwind('version'));
    }

    if (isset($compatibility)){
        function completion($set, $sql, $show_theme, $user_id, $moder, $admin, $creator)
        {
            $time = time();
            $meta_og = array();
            $user_id = Core::$user_id;
            if ($user_id){
                $user = Core::get_user($user_id);
            }
            include incDir . 'foot.php';
        }

        register_shutdown_function('completion', $set, $sql, $show_theme, $user_id, $moder, $admin, $creator);

        include H . 'engine/includes/compatibility.php';
    }

    new Core($set);
    ob_start();


    if (isset($user['lang']))
    {
        Core::set_lang($user['lang']);
    }
    elseif (isset($_COOKIE['language']))
    {
        Core::set_lang($_COOKIE['language']);
    }
