CREATE TABLE `meta_tags` (
  `id` int(12) NOT NULL auto_increment,
  `title` varchar(200) NOT NULL,
  `keywords` varchar(200) NOT NULL,
  `description` varchar(1000) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(150) NOT NULL,
  `name` varchar(40) NOT NULL,
  `img` varchar(40) NOT NULL,
  `pos` enum('top','bottom') NOT NULL DEFAULT 'top',
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `new_line` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `user` (
  `id` int(11) NOT NULL auto_increment,
  `nick` varchar(32) NOT NULL,
  `pass` varchar(32) NOT NULL,
  `sess` varchar(32) default NULL,
  `activation` varchar(32) default NULL,
  `group_access` int(10) unsigned NOT NULL default '0',
  `ip` bigint(20) NOT NULL default '0',
  `ua` varchar(500) default NULL,
  `date_reg` int(11) NOT NULL default '0',
  `date_aut` int(11) NOT NULL default '0',
  `date_last` int(11) NOT NULL default '0',
  `balls` int(11) NOT NULL default '0',
  `pol` enum('0','1') NOT NULL default '1',
  `ank_g_r` int(4) default NULL,
  `ank_m_r` int(2) default NULL,
  `ank_d_r` int(2) default NULL,
  `ank_city` varchar(32) default NULL,
  `ank_o_sebe` varchar(512) default NULL,
  `lang` varchar(5) default 'ru',
  `ank_icq` int(9) default NULL,
  `ank_mail` varchar(32) default NULL,
  `ank_n_tel` varchar(11) default NULL,
  `ank_name` varchar(32) default NULL,
  `set_them` varchar(32) default 'default',
  `gravatar` ENUM(  'yes',  'no' ) NOT NULL DEFAULT  'no',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `url` (`url`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `errors`(
`desc` varchar(300) NOT NULL,
`time` int(11) not null,
`ip` varchar(20) NOT NULL,
`user_agent` text NOT NULL,
`url` text NOT NULL,
`type` enum('server', 'php', 'mysql', 'loading'),
`user` varchar(40) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `modules` (
`name` VARCHAR(30) NOT NULL,
`ru_name` VARCHAR(30) DEFAULT NULL,
`desc` TEXT DEFAULT NULL,
`version` DECIMAL(3, 2),
`uninstaller` VARCHAR(60) DEFAULT NULL,
`author_name` VARCHAR(20) NOT NULL,
`author_e-mail` VARCHAR(20) DEFAULT NULL,
`author_icq` INT(9) DEFAULT NULL,
`author_wmid` INT(12) DEFAULT NULL,
PRIMARY KEY  (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE `ban` (
  `id` int(11) NOT NULL auto_increment,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `moder_id` int(11) NOT NULL,
  `prich` varchar(1024) NOT NULL,
  `view` set('1','0') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`, `moder_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `suspicious_users` (
`id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
`name` VARCHAR( 32 ) NOT NULL ,
`text` VARCHAR( 200 ) NOT NULL ,
PRIMARY KEY (  `id` )
) ENGINE = MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE  `smiles` (
`id` INT(11) NOT NULL AUTO_INCREMENT ,
`name` VARCHAR( 20 ) NOT NULL ,
`symbol` VARCHAR( 20 ) DEFAULT NULL ,
`type` ENUM(  'kat',  'smile' ) NOT NULL DEFAULT  'kat',
`parent_id` INT(11) NOT NULL ,
PRIMARY KEY (  `id` )
) ENGINE = MYISAM DEFAULT CHARSET=utf8;

INSERT INTO `smiles` (`id`, `name`, `symbol`, `type`, `parent_id`) VALUES
(1, 'Надписи', '', 'kat', 0),
(2, 'beta', '.бета.', 'smile', 1),
(3, 'Google', '.гугл.', 'smile', 1),
(4, 'help2', '.хелп.', 'smile', 1),
(5, 'krutoy', '.якрут.', 'smile', 1),
(6, 'lol', '.лол.', 'smile', 1),
(7, 'noflood', '.нефлуди.', 'smile', 1),
(8, 'owibochka', '.упс.', 'smile', 1),
(9, 'perviy_nah', '.перв.', 'smile', 1),
(10, 'vsempr', '.всемпр.', 'smile', 1),
(11, 'smile_t3', '.дану.', 'smile', 1),
(12, 'smile_t10', '.прот.', 'smile', 1),
(13, 'smile_t11', '.яза.', 'smile', 1);

CREATE TABLE IF NOT EXISTS `mail_contacts` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`user_id` int(11) NOT NULL,
`id_cont` int(11) NOT NULL,
`time` int(11) NOT NULL,
`unread` int NOT NULL,
`outbox` int NOT NULL,
`inbox` int NOT NULL,
PRIMARY KEY (`id`),
KEY `user_id` (`user_id`,`id_cont`),
KEY `unread` (`unread`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `mail` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`author` int(10) unsigned NOT NULL COMMENT 'Получатель',
`user` int(10) unsigned NOT NULL COMMENT 'Отправитель',
`time` int(10) unsigned NOT NULL COMMENT 'Время',
`text` varchar(1024) NOT NULL COMMENT 'Письмо',
PRIMARY KEY (`id`),
KEY `author` (`author`,`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Почта' AUTO_INCREMENT=1 ;
ALTER TABLE `mail` ADD `no` INT(2) NOT NULL DEFAULT "0";

CREATE TABLE IF NOT EXISTS `main_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(70) NOT NULL,
  `link` varchar(150) DEFAULT NULL,
  `icon` varchar(150) DEFAULT NULL,
  `file` varchar(150) DEFAULT NULL,
  `pos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

CREATE TABLE IF NOT EXISTS `speed_dial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `link` varchar(300) DEFAULT NULL,
  `icon` varchar(200) DEFAULT NULL,
  `pos` int(11) NOT NULL,
  `new_line` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=53 ;


INSERT INTO `speed_dial` (`id`, `name`, `link`, `icon`, `pos`, `new_line`) VALUES
(33, 'Установка', '/admin/modules/install.php', 'icons/cms.png', 12, 0),
(12, 'Менеджер Speed Dial', '', '', 7, 0),
(13, 'Добавить пункт', '?act=add', 'icons/add.png', 8, 0),
(14, 'Редактирование пунктов', '?act=editing', 'icons/config.png', 9, 0),
(15, 'Официальный сайт SecWind', 'http://secwind.ru', '/apple-touch-icon.png', 5, 0),
(16, 'Главная', '/', 'icons/index_page.png', 1, 0),
(31, 'Модули', '', '', 10, 0),
(18, 'Последняя версия SW', 'http://secwind.ru/pages/secwind.php', 'icons/last_ver.php', 2, 0),
(35, 'Службы', '/admin/modules/services.php', 'icons/help.png', 14, 0),
(21, 'Погода. Алматы', '?', 'icons/weather.php?city=almaty', 6, 0),
(32, 'Загрузить', '/admin/modules/upload.php', 'icons/download.png', 11, 0),
(34, 'Все модули', '/admin/modules/list.php', 'icons/info.png', 13, 0),
(36, 'Настройки', '/admin/modules/settings.php', 'icons/config.png', 15, 0),
(37, 'Сообщить об ошибке', 'http://secwind.ru/forum/index.php?forum=4', 'icons/bug.png', 4, 0),
(38, 'Документация', 'http://secwind.ru/blog/?show:blog/id:8/', 'icons/book.png', 3, 0),
(49, 'Резервное копирование', '', 'http://www.google.com/s2/favicons?domain=', 16, 0),
(50, 'Список Backup', '/admin/backup/list.php', '/admin/icons/info.png', 17, 0),
(51, 'Бекап файлов', '/admin/backup/files.php', '/admin/icons/archive.png', 18, 0),
(52, 'Бекап MySQL', '/admin/backup/mysql.php', '/admin/icons/db.png', 19, 0);

CREATE TABLE `module_services` (
  `name` varchar(50) not null,
  `file` varchar(100) not null,
  `desc` varchar(200) default null,
  `belongs` varchar(20) default null,
  `use_in` varchar(20) not null comment "todo: enum"
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `module_services` VALUES ('Пользователи', 'engine/services/users_service.php', 'Вывод онлайн юзеров ', 'Система', 'index_page');
INSERT INTO `module_services` VALUES ('Проверка нового юзера', 'engine/services/suspicious_user.php', 'Проверка юзера. Подробнее в админка/пользователи/подозрительные пользователи', 'Система', 'reg');
INSERT INTO `module_services` VALUES ('Инфо о бане (анкета)',  'engine/services/profile_user_ban.php', NULL ,  'Система',  'anketa');