<?php

/**
 * User: patsifist
 * Date: 28.07.14
 * Time: 15:16
 */
class Trike
{

    public static $obj;
    public $vars = array();
    public $configs = array();
    public $php_vars = array();

    public function __construct($configs = array())
    {
        Trike::$obj = $this;
        Trike::get_instance()->save_settings($configs);
    }

    public static function get_instance($configs = array())
    {
        if (is_null(Trike::$obj))
        {
            Trike::$obj = new Trike;//($configs);
        }

        if ($configs)
        {
            Trike::$obj->save_settings($configs);
        }

        return Trike::$obj;
    }

    public function save_settings($configs)
    {
        Trike::get_instance()->configs = $configs;//var_dump(Trike::get_instance()->configs);
        Trike::get_instance()->set_path();
    }


    public function set($search, $replace)
    {
        Trike::get_instance()->php_vars[$search] = $replace;

        if (is_array($replace))
        {
            foreach ($replace as $key => $value)
            {//echo $search . ' => '.$key, ' - ', $value . '<br />';
                Trike::get_instance()->vars[':' . $search . '=' . $key . ':'] = $value;
            }
        }
        else
        {
            Trike::get_instance()->vars[':' . $search . ':'] = $replace;
        }
    }

    public function if_parser($match)
    {//echo $match[1];
        //$tokens = explode('=', $match[1]);
        //if (isset($tokens[1])) {
            return "<?php if (".$match[1]."):?>";
        /*}
        else {
            return "<?php if (Trike::get_instance()->php_vars['".$tokens[0] . "']):?>";
        }*/
    }

    public function extract_parser($match)
    {
        return '<?php foreach (Trike::get_instance()->php_vars["' . $match[1] . '"] as $' . $match[2] . ' => $' . $match[3] . ')';
    }

    public function get_keys(&$value, $key)
    {
        $value = str_replace(':', null, $value);
        $value = '/:' . $value . ':/';
    }

    public function vars_parser($match)
    {
        $tokens = explode('=', $match[0]);//echo $match[0];

        return Trike::get_instance()->vars[$tokens[0] . (isset($tokens[1]) ? '=' . $tokens[1] : '')];
    }

    public function set_path()
    {
        if (is_file(H . '/style/themes/' . Core::$set['theme'] . '/tpl/' . Trike::get_instance()->configs['tpl_file']))
        {
            Trike::get_instance()->configs['tpl_dir'] = H . 'style/themes/' . Core::$set['theme'] . '/tpl/';
            Trike::get_instance()->configs['compile_dir'] = H . 'style/themes/' . Core::$set['theme'] . '/tpl/compile/';
        }
        else
        {
            Trike::get_instance()->configs['tpl_dir'] = H . 'style/tpl/';
            Trike::get_instance()->configs['compile_dir'] = tmpDir;
        }
    }

    public function is_compiled()
    {
        //if (!Trike::get_instance()->configs)
        //var_dump(Trike::get_instance()->configs);
        if (Trike::get_instance()->configs['compile'] == false)
            return false;

        $file = Trike::get_instance()->configs['compile_dir'] . Trike::get_instance()->configs['tpl_file'] . '~'.Trike::get_instance()->configs['id'];

        if (is_file($file))
        {
            include $file;
            return true;
        }

        return false;
    }

    public function compilation($code)
    {
        if (Trike::get_instance()->configs['compile'] == true)
        {
            $file = Trike::get_instance()->configs['compile_dir'] . Trike::get_instance()->configs['tpl_file'] . '~'.Trike::get_instance()->configs['id'];
            file_put_contents($file, $code);
        }
    }

    public function display($reset = false)
    {
        if (!Trike::get_instance()->is_compiled())
        {
            $result = Trike::get_instance()->parser();
            Trike::get_instance()->compilation($result);
            eval('?>'.$result);
        }
        if ($reset)
        {
            Trike::get_instance()->reset();
        }
    }

    public function parser()
    {
        $code = file_get_contents(Trike::get_instance()->configs['tpl_dir'] . Trike::get_instance()->configs['tpl_file']);
        $keys = array_keys(Trike::get_instance()->vars);
        array_walk_recursive($keys, array(Trike::get_instance(), 'get_keys'));
        $code = str_replace(array('[', ']', 'else', 'endif'), array('{?>', "<?\n}?>", ' <? else: ?>', '<?endif?>'), $code);

        $code = preg_replace_callback("/if \{(.*)\}/", array(Trike::get_instance(), 'if_parser'), $code);
        $code = preg_replace_callback(
            "/extract \{:(.*): as :(.*): and :(.*):\}/",
            array(Trike::get_instance(), 'extract_parser'),
            $code
        );
        $code = preg_replace_callback($keys, array(Trike::get_instance(), 'vars_parser'), $code);

        //echo '<pre>' . htmlspecialchars($code) . '</pre>';
        return $code;
    }

    public function reset()
    {
        Trike::get_instance()->vars = Trike::get_instance()->php_vars = null;
        Trike::get_instance()->configs = array();
    }
}