<?php

/**
 * @author Tadochi <Tadochi@spaces.ru>
 */
 
Class Page
{
    public $k_post, $start, $k_page, $l_post, $page = 1;

    public function __construct($k_post, $l_post)
    {
        $this->k_post = $k_post;

        $this->l_post = $l_post;
    }

    public function __toString()
    {
        return $this->k_post;
    }

    /*
    function __get($var)
    {
        return $this->$var();
    }
    */

    public function limit()
    {
        return $this->start() . ', ' . $this->l_post;
    }

    public function pager()
    {
        $this->page = 1;

        if (isset($_GET['page'])) {
            if ($_GET['page'] == 'end') {
                $this->page = intval(self::k_page());
            } elseif (is_numeric($_GET['page'])) {
                $this->page = intval($_GET['page']);
            }
        }

        if ($this->page < 1) {
            $this->page = 1;
        }

        return $this->page;
    }

    public function start()
    {
        return $this->start = $this->l_post * self::pager() - $this->l_post;
    }

    public function k_page()
    {
        if ($this->k_post) {
            return $this->k_page = ceil($this->k_post / $this->l_post);
        }

        return $this->k_post;
    }



    public function display($link = '?')
    {
        $following = $previous = array();
        $links = array(
            'first'         => false, 'prev' => false, 'this' => $this->pager(), 'next' => false,
            'last' => false, 'href' => $link . 'page=', 'total' => $this->k_page(),
            'items_on_page' => Core::$set['p_str'], 'current' => $this->pager(),
        );

        if ($this->k_page() > 1) {

            if ($this->pager() > 1) {
                $links['prev'] = $this->pager() - 1;
            }

            if ($this->pager() < $this->k_page()) {
                $links['next'] = ($this->pager() + 1);
            }

            if ($this->k_page() > ($this->pager() + 2)) {
                $links['last'] = true;
            }

            if ($this->pager() != 1) {
                $links['first'] = true;
            }
            //else echo '<span class="page_no">1</span>';

            for ($ot = -3; $ot <= 3; $ot++)
            {
                if (($this->pager() + $ot > 1) && ($this->pager() + $ot < $this->k_page()))
                {
                    if ($ot)
                    {
                        if ($ot < 0)
                        {
                            $previous[] = $this->pager() + $ot;
                        }
                        else
                        {
                            $following[] = $this->pager() + $ot;
                        }
                    } else {
                        $links['this'] = $this->pager() + $ot;
                    }
                }
            }
        }

        global $fenom;

        $vars['links'] = $links;
        $vars['following'] = $following;
        $vars['previous'] = $previous;
        $fenom->display('pagination.tpl', $vars);
    }
}