<?php

   /**
	* @author Tadochi
	*/

    class My_sqli
	{
		public $db, $db_config;
		public $error;
		public $result = null; // Результат последнего запроса
		public $logs = array();
        public $timer, $using_time;
        public $queries = 0;
        public $log_id = 1;

		public function __construct($set)
		{
            $this->db_config = $set;
			return $this->db;
		}

        public function connect()
        {
            $this->timer = microtime(1);
            $this->db = mysqli_connect($this->db_config['mysql_host'], $this->db_config['mysql_user'], $this->db_config['mysql_pass'], $this->db_config['mysql_db_name']);
            $this->log('Соединение с базой данных');
            $this->timer = microtime(1);
            mysqli_set_charset($this->db, 'utf8'); //mysqli_query($this->db, 'SET NAMES utf8');
            $this->log('Установка кодировки по умолчанию');
            return $this->db;
        }

        public function __destruct()
        {
            $this->free();
			mysqli_close($this->db);
        }
		
		public function log($msg)
		{
			$timer = round(microtime(1) - $this->timer, 4);
			$this->using_time += $timer;
			$this->logs[$this->log_id++ . ') ' . $timer . ' sec'] = $msg;
		}
		
		public function table_exists($table)
		{
            if ($this->db == null)
            {
                $this->connect();
            }

			$this->timer = microtime(1);
			$return = $this->query("SHOW TABLES LIKE '$table'")->result();
			$this->log('Проверка существования таблицы '. $table);
			return $return;
		}
		
        public function free($multi = false)
        {
            if ($this->db == null)
            {
                $this->connect();
            }

			$this->timer = microtime(1);
			if ($multi)
			{
				do
				{
					if (!mysqli_more_results($this->db))
					break;

					if ($result = mysqli_store_result($this->db))
					{
						mysqli_free_result($result);
					}
				}
				while (mysqli_next_result($this->db));
			}

            if (!empty($this->result) && !is_bool($this->result))
                mysqli_free_result($this->result);
			$this->result = null;
			$this->log('Очистка результатов запроса');
        }

        public function num_rows($query = false)
        {
			$this->timer = microtime(1);
			$return = mysqli_affected_rows($this->db);
			$this->log('Выполнение mysqli_affected_rows');
			return $return;
        }

        public function result($query = false)
		{

			if (!$query)
                $query = $this->result;
			$this->timer = microtime(1);
            $result = mysqli_fetch_row($query);
			$this->log('Выполнение mysqli_fetch_row');
			return $result[0];
		}
		
		public function fetch($query = false)
		{
			if (!$query)
                $query = $this->result;
			$this->timer = microtime(1);
            $return = mysqli_fetch_assoc($query);
			$this->log('Выполнение mysqli_fetch_assoc');
			return $return;
		}

        public function from_file($file)
        {
            if (file_exists($file))
			{
				$this->log('Выполнение запросов из файла '.$file);
                return $this->multi(file_get_contents($file));
			}
		}
		
        public function multi($query)
        {
            if ($this->db == null)
            {
                $this->connect();
            }

            $this->timer = microtime(1);
            $this->result = mysqli_multi_query($this->db, $query);
            $count = substr_count($query, ';');
            $this->queries += $count;
			$this->log('Выполнение запросов: '. $count);
			$this->error = mysqli_error($this->db);
			return $this->result;
        }
		
		public function query($query, $free = false)
		{
            if ($this->db == null)
            {
                $this->connect();
            }

			$this->timer = microtime(1);
            $result = mysqli_query($this->db, $query);
			$this->log('Выполнение запроса: '.$query);
            $this->error = mysqli_error($this->db);
            $this->queries++;

            if ($free)
                mysqli_free_result($result);
            else
                $this->result = $result;

            if (!empty($this->error))
            {
                mysqli_query($this->db, "
                    INSERT INTO `errors`
                    (`user`, `time`, `user_agent`, `ip`, `desc`, `type`, `url`) VALUES 
                    ('".Core::$user_id."', '".time()."', '".my_esc($_SERVER['HTTP_USER_AGENT'], true)."', '".my_esc($_SERVER['REMOTE_ADDR'], true)."', '".my_esc($this->error)."', 'mysql', '".my_esc($_SERVER['REQUEST_URI'], true)."');");
				$this->error = null;
			}

			return $this;
		}

        public function esc($str)
        {
            if ($this->db == null)
            {
                $this->connect();
            }
            return mysqli_real_escape_string($this->db, $str);
        }
	}
	
	return new My_sqli($set);