<?php
    include '../../engine/includes/start.php';
    if (!$creator)
        Core::stop();

    if (isset($_GET['file'], $_GET['type'])
        && is_file(H . 'engine/files/backup/'.$_GET['type'].'/'.$_GET['file']))
    {
        $path = H . 'engine/files/backup/'.Core::Request('type').'/'.Core::Request('file');
        $file = pathinfo($path);
    }
    else
    {
        Core::stop('list.php?msg=404');
    }

    $set['title'] = 'Просмотр бекапа';
    require incDir.'head.php';
    
    $dropbox = is_file(H . 'engine/files/data/dropbox.ini') ?
        parse_ini_file(H . 'engine/files/data/dropbox.ini') :
        array('e-mail' => '', 'password' => '');

    switch($act)
    {
        case 'delete':
            unlink($path);
            Core::stop('list.php?msg=deleted');
        break;

        case 'restore':
            $zip = new Pclzip($path);
            $zip->extract(PCLZIP_OPT_SUBSTITUE_FILE, H);
            Core::msg_show('Восстановление по бекапу прошло успешно');
        break;

        case 'load':
            Core::get('downloadfile', 'includes');
            DownloadFile($path, $file['basename']);
        break;

        case 'dropbox':
            if (!empty($dropbox['e-mail']))
            {
                if (empty($dropbox[$act . '_' . $file['basename']]))
                {
                    $uploader = new DropboxUploader($dropbox['e-mail'], $dropbox['password']);
                    try
                    {
                        $uploader->upload($path, 'secwind_'.$_SERVER['SERVER_NAME'].'/backups/'.Core::Request('type').'/', $file['basename']);
                        Core::msg_show('Успешно отправлен на Dropbox', 'msg');
                        $dropbox[$act . '_' . $_GET['dropbox']] = true;
                    }
                    catch (Exception $e)
                    {
                        $label = ($e->getCode() & $uploader::FLAG_DROPBOX_GENERIC) ? 'DropboxUploader' : 'Exception';
                        $error = sprintf("[%s] #%d %s", $label, $e->getCode(), $e->getMessage());
                        Core::msg_show(htmlspecialchars($error), 'error');
                    }
                }
                else
                {
                    Core::msg_show('Уже в Dropbox', 'msg');
                }
            }
        break;
	}

    ?>
    <div class="post">
        <b>Файл:</b> <?=$file['basename']?><br />
        <b>Папка:</b> <?=$file['dirname']?><br />
        <b>Размер:</b> <?=Text::size_data(filesize($file['dirname'] . '/' . $file['basename']))?><br />
        <b>MD5:</b> <?=md5_file($file['dirname'] . '/' . $file['basename'])?><br />
        <b>SHA1:</b> <?=sha1_file($file['dirname'] . '/' . $file['basename'])?><br />
    </div>
    <div class="menu_razd">Действия</div>
        <a href="?act=load&amp;file=<?=Core::Request('file')?>&amp;type=<?=Core::Request('type')?>" class="link">Скачать</a>
        <a href="?act=delete&amp;file=<?=Core::Request('file')?>&amp;type=<?=Core::Request('type')?>" class="link">Удалить</a>
        <a href="?act=restore&amp;file=<?=Core::Request('file')?>&amp;type=<?=Core::Request('type')?>" class="link">Восстановить</a>
    <div class="menu_razd">Отправить на</div>
        <a href=""><img src=""/>E-MAIL</a>
        <a href="?act=dropbox&amp;file=<?=Core::Request('file')?>&amp;type=<?=Core::Request('type')?>"><img src=""/>DROPBOX</a>
        <a href=""><img src=""/>YANDEX</a>
        <a href=""><img src=""/>GOOGLE DISK</a>
        <a href=""><img src=""/>MAIL</a>
    <?php

    Core::save_settings($dropbox, 'engine/files/data/dropbox.ini');

    ?>
    <div class="menu_razd">См. также</div>
	<a href='/admin/backup/files.php'><div class="link">Резервное копирование файлов</div></a>
	<a href='mysql.php'><div class="link">Резервное копирование базы данных</div></a>
    <a href='/admin/'><div class="link">Админка</div></a>
    <?
    require incDir.'foot.php';