CREATE TABLE IF NOT EXISTS `forum_favourites` (
  `topic` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `topic` (`topic`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `topic` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` int(2) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `down` int(11) NOT NULL,
  `plus` int(11) NOT NULL,
  `minus` int(11) NOT NULL,
  `rating` int(1) NOT NULL,
  `tempid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`topic`,`type`,`user_id`),
  KEY `tempid` (`tempid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `realid` int(11) NOT NULL,
  `refid` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `last_topic` varchar(250) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`,`refid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_journal` (
  `time` int(11) NOT NULL,
  `user_id` int(10) NOT NULL,
  `text` text NOT NULL,
  `readed` int(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_polled` (
  `refid` int(11) NOT NULL,
  `poll` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `refid` (`refid`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `count` (`count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `text` text NOT NULL,
  `edit` varchar(150) NOT NULL DEFAULT '',
  `files` int(1) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`files`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts_del` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `text` text NOT NULL,
  `edit` varchar(150) NOT NULL DEFAULT '',
  `files` int(1) NOT NULL,
  `browser` varchar(250) NOT NULL,
  `ip` bigint(11) NOT NULL,
  `ip_via_proxy` bigint(11) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `plus_minus` varchar(50) NOT NULL DEFAULT '0|0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`files`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_posts_rating` (
  `refid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  KEY `refid` (`refid`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_readed` (
  `topic` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `lastpost` int(11) NOT NULL,
  PRIMARY KEY (`topic`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `forum_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `forum` varchar(150) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user` varchar(40) NOT NULL,
  `lastpost` varchar(250) NOT NULL,
  `count` int(11) NOT NULL,
  `close` tinyint(1) NOT NULL,
  `sticky` tinyint(1) NOT NULL,
  `clip` tinyint(1) NOT NULL,
  `poll_name` varchar(250) NOT NULL,
  `poll_set` text NOT NULL,
  `curator` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`,`time`,`user_id`,`sticky`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `module_services` (`name`, `file`, `desc`, `belongs`, `use_in`) VALUES
  ('Форум', 'engine/services/forum_service.php', 'Выводит ссылку в форум. Есть счетчик всех сообщений, и тем', 'forum', 'index_page');

INSERT INTO `main_menu` (`name`, `link`, `icon`, `file`, `pos`) VALUES
  ('Форум', 'forum', '/style/icons/forum.png', 'engine/services/forum_service.php', 3);
  
  INSERT INTO `modules` (`name`, `ru_name`, `desc`, `version`, `uninstaller`, `author_name`, `author_e-mail`, `author_icq`, `author_wmid`) VALUES
('forum', 'Форум', '- создание разноуровневых форумов ( форум -> подфорум -> тема, форум -> тема)\r\n- назначение иконки для форума (закинуть иконку 16*16 в папку files/forum/icons/Id_форума.png)\r\n- создание голосования с мультивыбором вариантов\r\n- создавший тему пользователь всегда может изменять её первый пост\r\n- мультиприкрепление файлов к сообщению (до 10 штук), редатирование ранее прикрепленных файлов\r\n- просмотр собственной активности (темы, сообщения, файлы)\r\n- избранные темы (типа закладки)\r\n- рейтинг сообщений\r\n- преход к последнему прочтенному сообщению темы\r\n- авторедирект после основных операций на форуме в 1 сек. (работает не во всех браузерах, поэтому продублирован ссылкой)\r\n- журнал форума (оповещение об перемещении, переименовании? удалении темы, ответе на сообщение)', 1.00, 'forum/uninstall.php', 'seg0ro', NULL, NULL, NULL),

INSERT INTO `module_services` VALUES('Счетчик форума', 'engine/services/profile_forum_service.php', 'Вывод кол. тем и постов юзера', 'forum', 'anketa');
  