CREATE TABLE `mod_lib` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `announce` varchar(255) NOT NULL,
  `tags` varchar(255) NOT NULL,
  `type` varchar(3) NOT NULL,
  `time` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `author_name` varchar(25) NOT NULL,
  `counter` int(11) NOT NULL DEFAULT '0',
  `mod` tinyint(1) NOT NULL DEFAULT '0',
  `count_arc` int(11) NOT NULL,
  `comm_count` int(11) NOT NULL,
  `views` int(11) NOT NULL,
  `uni_views` int(11) NOT NULL,
  `rate_plus` int(11) NOT NULL,
  `rate_minus` int(11) NOT NULL,
  `edit_name` varchar(25) NOT NULL,
  `edit_id` int(11) NOT NULL,
  `edit_time` int(11) NOT NULL,
  `down_time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `name` (`name`),
  FULLTEXT KEY `announce` (`announce`),
  FULLTEXT KEY `text` (`text`),
  FULLTEXT KEY `tags` (`tags`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE `mod_lib_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE `mod_lib_counters` (
  `uid` varchar(32) NOT NULL,
  `aid` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`uid`,`aid`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `mod_lib_files` (
  `aid` int(11) NOT NULL,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`aid`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `mod_lib_set` (
  `key` varchar(5) NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `mod_lib_set` SET `val`='a:5:{s:9:"main_deal";i:10;s:8:"zip_deal";i:10;s:9:"mod_close";i:0;s:5:"files";a:2:{s:10:"extensions";a:22:{i:0;s:3:"png";i:1;s:3:"jpg";i:2;s:3:"bmp";i:3;s:3:"gif";i:4;s:3:"zip";i:5;s:3:"rar";i:6;s:2:"7z";i:7;s:3:"jar";i:8;s:3:"tar";i:9;s:3:"mp3";i:10;s:3:"amr";i:11;s:3:"aac";i:12;s:3:"m4a";i:13;s:3:"wav";i:14;s:3:"mp4";i:15;s:3:"avi";i:16;s:3:"3gp";i:17;s:3:"exe";i:18;s:3:"bin";i:19;s:3:"txt";i:20;s:4:"conf";i:21;s:3:"log";}s:10:"max_number";i:10;}s:19:"tags_max_cache_time";i:86400;}', `key` = 'set';

INSERT INTO `module_services` (`name`, `file`, `desc`, `belongs`, `use_in`) VALUES
  ('Библиотка', 'engine/services/lib_service.php', 'Выводит ссылку в библиотеку. Есть счетчик всех категорий и статей', 'lib', 'index_page');

INSERT INTO `main_menu` (`name`, `link`, `icon`, `file`, `pos`) VALUES
  ('Библиотека', '/lib/', '/style/icons/lib.png', 'engine/services/lib_service.php', 5);

INSERT INTO `modules` (`name`, `ru_name`, `desc`, `version`, `uninstaller`, `author_name`, `author_e-mail`, `author_icq`, `author_wmid`) VALUES
  ('lib', 'Библиотека', 'Категории\r\n- Создание/Редактирование/Удаление/Перемещение\r\n- Возможность перемещения и удаления сразу нескольких категорий из админ панели (удаление возможно только если категории пусты)\r\n- Неограниченная вложенность категорий\r\n- Возможно хранить в категории категории и статьи вместе\r\n- Сортировка содержимого по имени, кол-ву комментариев, рейтингу и т.п.\r\nСтатьи\r\n- Создание (есть возможность добавлять статьи пользователям, если это позволяют настройки категории, при добавлении статья отправляется на модерацию)\r\n- Загрузка статьи из txt файла\r\n- Загрузка до 40 статей сразу, из zip архива\r\n- Редактирование/Удаление\r\n- Прикрепление файлов к статьям (максимум 40 файлов)\r\n- BB код для вставки изображений\r\n- Рейтинг\r\n- Комментарии (используется класс комментариев имеющийся в дистрибутиве JohnCMS 4.4.0)\r\n- Счетчики просмотров (Уникальные / Повторяющиеся)\r\n- Разбивка текста по страницам при просмотре статьи (Есть возможность настроить кол-во строк на страницу)\r\n- Метки\r\n- Возможно перемещать и удалять сразу несколько статей из админ панели\r\n- Добавление статьи в личные закладки\r\n- Список новых статей (находится на главной странице модуля)\r\nПоиск\r\n- по заголовку/анонсу (описанию)/тексту/меткам\r\nПанель управления\r\n- Список статей находящихся на модерации\r\n- Настройки\r\n- Управление статьями и категориями (Массовое перемещение и удаление) ', 1.00, 'lib/uninstall.php', 'Screamer', NULL, NULL, NULL);
