<?php 
# @*************************************************************************@
# @ Software author: Mansur Terla (Mansur_TL)                               @
# @ UI/UX Designer & Web developer ;)                                       @
# @                                                                         @
# @*************************************************************************@
# @ Instagram: https://www.instagram.com/mansur_tl                          @
# @ VK: https://vk.com/mansur_tl_uiux                                       @
# @ Envato: http://codecanyon.net/user/mansur_tl                            @
# @ Behance: https://www.behance.net/mansur_tl                              @
# @ Telegram: https://t.me/mansurtl_contact                                 @
# @*************************************************************************@
# @ E-mail: mansurtl.contact@gmail.com                                      @
# @ Website: https://www.mansurtl.com                                       @
# @*************************************************************************@
# @ ColibriSM - The Ultimate Social Network PHP Script                      @
# @ Copyright (c)  ColibriSM. All rights reserved                           @
# @*************************************************************************@

if (empty($_GET["uname"])) {
	require_once cl_full_path("apps/native/http/err404/content.php");
}
else{

	$uname           = fetch_or_get($_GET["uname"], false);
	$uname           = cl_text_secure($uname);
	$cl['prof_user'] = cl_get_user_by_name($uname);
	$cl['page_tab']  = fetch_or_get($_GET["tab"], 'posts');

	if (empty($cl['prof_user'])) {
		require_once cl_full_path("apps/native/http/err404/content.php");
	}

	else{
		require_once(cl_full_path("core/apps/profile/app_ctrl.php"));

		$cl["page_title"]  = $cl['prof_user']['name'];
		$cl["page_desc"]   = $cl['prof_user']['about'];
		$cl["page_img"]    = $cl['prof_user']['avatar'];
		$cl["page_kw"]     = $cl["config"]["keywords"];
		$cl["pn"]          = "profile";
		$cl["page_xdata"]  = array();
		$cl["sbr"]         = true;
		$cl["sbl"]         = true;
		$cl["user_posts"]  = array();
		$cl["user_likes"]  = array();
		$cl["can_view"]    = cl_can_view_profile($cl['prof_user']['id']);
		$cl["app_statics"] = array(
			"scripts" => array()
		);

		if (not_empty($cl["is_logged"])) {
			$cl['prof_user']['is_blocked'] = false;
			$cl['prof_user']['me_blocked'] = false;

			if (($cl['prof_user']['id'] != $me['id'])) {
				$cl['prof_user']['is_blocked'] = cl_is_blocked($me['id'], $cl['prof_user']['id']);
				$cl['prof_user']['me_blocked'] = cl_is_blocked($cl['prof_user']['id'], $me['id']);
			}

			$cl['prof_user']['owner']            = ($cl['prof_user']['id'] == $me['id']);
			$cl['prof_user']['is_following']     = cl_is_following($me['id'], $cl['prof_user']['id']);
			$cl['prof_user']['follow_requested'] = false;
			$cl['prof_user']['common_follows']   = cl_get_common_follows($cl['prof_user']['id']);
			$cl['prof_user']['is_myfollower']    = cl_is_following($cl['prof_user']['id'], $me["id"]);

			if (empty($cl['prof_user']['is_following'])) {
				$cl['prof_user']['follow_requested'] = cl_follow_requested($me['id'], $cl['prof_user']['id']);
			}
			 
			if (not_empty($cl['prof_user']['owner'])) {

				$cl["page_xdata"]["is_me"] = true;

				$cl["app_statics"]["scripts"] = array(
					cl_js_template("statics/js/libs/jquery-ui")
				);
			}

			if ($me["id"] != $cl['prof_user']['id']) {
				cl_notify_user(array(
		            'subject'  => 'visit',
		            'user_id'  => $cl['prof_user']['id'],
		            'entry_id' => $me["id"]
		        ));

		        $cl['prof_user']['me_subscribed'] = cl_is_subscribed($me["id"], $cl['prof_user']['id']);

		        if ($cl['prof_user']['me_subscribed']) {
		        	$cl['prof_user']['subscribtion_data'] = cl_my_subscribtion_data($me["id"], $cl['prof_user']['id']);
		        }
			}
		}

		if (empty($cl['prof_user']['is_blocked']) && empty($cl['prof_user']['me_blocked']) && $cl['prof_user']['active'] == "1") {
			if (in_array($cl['page_tab'], array('posts', 'media'))) {

				$cl["profile_pinned_post"] = cl_get_profile_pinned_post($cl['prof_user']['id']);

				if (not_empty($cl["can_view"])) {
					$media_type       = (($cl['page_tab'] == 'media') ? true : false);
					$cl["user_posts"] = cl_get_profile_posts($cl['prof_user']['id'], 30, $media_type);
				}
			}

			else {
				if (not_empty($cl["can_view"])) {
					$cl["user_likes"] = cl_get_profile_likes($cl['prof_user']['id'], 30);
				}
			}
		}

		$cl["http_res"] = cl_template("profile/content");
	}
}
