<?php

use app\models\User;
use app\commands\Rounding;
use yii\widgets\LinkPager;
use yii\helpers\Html;
use app\models\active\Corp;

$this->title = 'Рейтинг';

?>

<div class="content">
    <div class="feedback">
        <img width="24" height="24" alt="" src="/images/header/money_36.png">Рейтинг по
        <span><?php echo $rateArray[$type]['name']; ?></span></div>
    <div>

        <div class="feedback" style="text-align: left;">
            <?php foreach ($all as $res): ?>

                <div style="margin-top: 4px;">
                    <span class="fl nobr"> <?php echo User:: findUser($res['id']); ?></span>    </a>

                    <span class="fr nobr"><img width="18" height="18" alt=""
                                               src="<?php echo $rateArray[$type]['icon']; ?>"><span>
				<?php echo Rounding:: Number($res[$rateArray[$type]['desc']], 2, $type); ?></span></span>
                    <div class="cb"></div>
                </div>

                <?php $count++; ?>
            <?php endforeach; ?>
        </div>

        <div class="center" style="margin-top: 2px;">

            <div class="center">
                <?= LinkPager::widget(['pagination' => $pagination]) ?>
            </div>

        </div>
        <div class="minor mt4">Вы находитесь на
            <span><?php echo User:: Rating(Yii::$app->user->id, $rateArray[$type]['desc']); ?></span> месте в рейтинге!
        </div>
    </div>
</div>

<div class="content">
    <?php foreach ($rateArray as $key => $res): ?>

        <?php if ($key == $type): ?>

            <div class="blocks">
                <?= Html::tag('span', 'По ' . $res['name'], ['class' => 'btnl mt4']) ?>
            </div>

        <?php else: ?>

            <div class="blocks">
                <?= Html::a('По ' . $res['name'], ['rating', 'type' => $key, 'page' => floor(User:: Rating(Yii::$app->user->id, $res['desc']) / 10) + 1], ['class' => 'btnl mt4']) ?>
            </div>

        <?php endif; ?>

    <?php endforeach; ?>


    <div class="blocks">
        <?= Html::a('Рейтинг корпораций', ['/corp/rating', 'page' => floor(Corp:: CorpRatingPage() / 10) + 1], ['class' => 'btnl mt4']) ?>
    </div>
</div>
		
		