<?php
/**
 * Market View;
 * @author OlegKulaga(Medan)
 */

use app\models\User;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Аукцион';
?>

<div class="mt4 center feedback"><?php echo $this->title; ?></div>

<?php if ($action == 'newLot'): ?>
    <div class="feedback" style="margin-bottom: 4px;">
        <u>
            Новый лот
        </u>
    </div>
    <div class="content">
        <div style="text-align: center;padding: 4px;">
            Стоимость размещения -<img src="/images/ruby.png" alt="r" width="18" height="18">100 на 24 часа.
        </div>
        <div class="mt4 center" style="padding: 4px;">

            <?php $form = ActiveForm::begin(['id' => 'addLot', 'fieldConfig' => [
                'template' => '{label}<br><div class="center">{input}</div>
        <div class="p5 alert">{error}</div>',
            ]]); ?>

            <?php echo $form->field($model, 'keys')->textInput(['class' => 'form-control', 'placeholder' => Yii::$app->user->identity->_key]); ?>
            <?php echo $form->field($model, 'cost')->textInput(['class' => 'form-control']); ?>

            <input type="submit" value="Добавить" class="mt4 btn btn-success">

            <?php ActiveForm::end() ?>
        </div>
        <div class="blocks">
            <a class="btnl mt4" href="/market">Рынок</a>
        </div>
    </div>

<?php elseif ($action == 'myLots'): ?>
    <div class="feedback" style="margin-bottom: 4px;">
        <u>
            Мои лоты
        </u>
    </div>
    <div class="content">
        <?php if (empty($lots)): ?>
            Пусто
        <?php else: ?>
            <table width="100%" border="1" bordercolor="#545e54" cellspacing="0">
                <?php foreach ($lots as $lot): ?>
                    <tr>
                        <td width="70%" style="padding: 4px">
                            <i class="fa fa-key" aria-hidden="true"></i><?php echo $lot['keys'] ?> за <img
                                    src="/images/ruby.png" alt="r" width="18" height="18"><?php echo $lot['cost'] ?>
                            <span class="tgray" style="font-size: 12px;">
                            <?php if ($lot['time'] > time()): ?>
                                (Истечет <?php echo Yii::$app->formatter->format($lot['time'], 'relativeTime') ?>)
                            <?php else: ?>
                                (Просрочен)
                            <?php endif; ?>
                        </span>
                        </td>
                        <td width="30%">
                            <a class="btnl center" href="javascript:void(0);"
                               onclick="removeLot(<?php echo $lot['id']; ?>);" style="font-size: 12px;">
                                Удалить
                            </a>
                            <a class="btnl center" href="javascript:void(0);"
                               onclick="extendLot(<?php echo $lot['id']; ?>);" style="font-size: 12px;">
                                Продлить
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <div class="center">
                <?= \yii\widgets\LinkPager::widget(['pagination' => $pagination]) ?>
            </div>

            <?php
            $script = <<< JS

            function removeLot(id){
                swal({
                    title: "Вы уверены, что хотите удалить лот №"+ id +"?",
                    text: "",
                    buttons: {
                        text: "Да",
                        cancel: "Нет"
                    }
                }).then(function(isConfirm) {
                  if(isConfirm){
                      document.location.assign('/market?action=myLots&remove='+id);
                  }
                });
            }
            
            function extendLot(id){
                swal({
                    title: "Вы уверены, что хотите продлить лот №"+ id +" за 100 рубинов?",
                    text: "",
                    buttons: {
                        text: "Да",
                        cancel: "Нет"
                    }
                }).then(function(isConfirm) {
                  if(isConfirm){
                      document.location.assign('/market?action=myLots&extend='+id);
                  }
                });
            }
JS;
            $this->registerJs($script, $this::POS_END);
            ?>
        <?php endif; ?>

        <div class="blocks">
            <a class="btnl mt4" href="/market">Рынок</a>
        </div>
    </div>
<?php else: ?>

    <div class="content">
    <div class="blocks">
        <a class="btnl mt4" href="/market?action=newLot"> Новый лот</a>
    </div>
    <div class="blocks">
        <a class="btnl mt4" href="/market?action=myLots"> Мои лоты</a>
    </div>
    <div class="blocks">
        <a class="btnl mt4" href="/user/journal"> Успешные продажи
            <?php if(!empty($journal)): ?>
                <span class="tgreen">+</span>
            <?php endif; ?>
        </a>
    </div>

    <?php if (empty($lots)): ?>
        Пусто
    <?php else: ?>
        <div class="feedback">
            <table width="100%" cellspacing="0" border="1" bordercolor="#545e54">
                <?php foreach ($lots as $lot): ?>
                    <tr>
                        <td width="25%">
                            <?php echo User::findUser($lot['user_id']); ?>
                        </td>
                        <td width="50%" style="padding: 4px">
                            <i class="fa fa-key" aria-hidden="true"></i><?php echo $lot['keys'] ?> за <img
                                    src="/images/ruby.png" alt="r" width="18" height="18"><?php echo $lot['cost'] ?>
                            <span class="tgray" style="font-size: 12px;">
                            (Истечет <?php echo Yii::$app->formatter->format($lot['time'], 'relativeTime') ?>)
                        </span>
                        </td>
                        <td width="25%">
                            <?php if ($lot->user_id == Yii::$app->user->identity->id): ?>
                                <span class="tgray" style="font-size: 10px;padding: 4px;">ваш лот</span>
                            <?php else: ?>
                                <a class="btnl center" href="javascript:void(0);"
                                   onclick="buyLot(<?php echo $lot['id']; ?>, <?php echo $lot['cost']; ?>);"
                                   style="font-size: 12px;">
                                    купить
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <div class="center">
            <?= \yii\widgets\LinkPager::widget(['pagination' => $pagination]) ?>
        </div>
        </div>
        <?php
        $script = <<< JS

            function buyLot(id, cost){
                swal({
                    title: "Вы уверены, что хотите купить лот №"+ id +" за "+ cost +" рубинов?",
                    text: "",
                    buttons: {
                        text: "Да",
                        cancel: "Нет"
                    }
                }).then(function(isConfirm) {
                  if(isConfirm){
                      document.location.assign('/market?buy='+id);
                  }
                });
            }
JS;
        $this->registerJs($script, $this::POS_END);
        ?>
    <?php endif; ?>
<?php endif; ?>
