<?php


use yii\helpers\Html;
use app\assets\AppAsset;
use app\models\User;
use app\commands\Rounding;
use app\models\active\Tourney;

AppAsset::register($this);

Tourney:: Outcome();

?>

<?php
$script = <<< JS

	function getRandomIntFromRange(min, max) {
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min)) + min;
}



    function Tourney()
	{

	$.getJSON('/ajax/tourney', function(data) {
	    if(data.status == 'info'){
	swal({
    title: data.title,
    text: data.text,
    buttons: {
      text: "Подробнее",
      cancel: "Скрыть"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){

		location = data.url;

      }
    }
  );

	    }


	});

}


	function MoneyUser()
	{
		$.getJSON('/ajax/user', function(data) {
			$('#money').html(data.money);
			$('#income').html(data.income);
		});
	}

	function Notice()
	{
		$.getJSON('/ajax/notice', function(data) {



			swal(data.title,  data.text,  data.status);
		});
	}

	function Income()
	{

		$.get('/ajax/income', {usid: ''}, function(data){
			MoneyUser();
			$(".leprechaun").animate({top: "300"}, 2000);
		});

	}

	function MailNew()
	{

	    $.getJSON('/ajax/mail-new', {usid: ''}, function(data){
			if(data.status == 1) $('#mail').attr('src', '/images/header/mail_new.png');
		});


	}

	function key()
	{

		$.getJSON('/ajax/key-give', function(data) {

		if(data.status == 'success') {

		$('#count-key').html(data.key);
		$('.leprechaun').hide();
		$(".key").animate({top: "300"}, 100);
		$('.key').fadeIn(1000);
		$('.key').fadeOut(3000);
		//swal('Получен 1 ключ',  '',  'success');

		}

		});

	}





	$.getJSON('/ajax/key', function(data) {

		if(data.status == 'success') {

			var left = getRandomIntFromRange(30, 58);

			$('.leprechaun').css('left', left+'%');
			$('.key').css('left', left+'%');
			$('.leprechaun').show();

		}

	});

	setInterval(Income,10000);
	setInterval(MailNew,10000);
	Tourney();
	Notice();
	Income();
JS;

$this->registerJs($script, $this::POS_END);
?>


<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>
<script src="https://kit.fontawesome.com/65fb98eaeb.js" crossorigin="anonymous"></script>
<?php if (!Yii::$app->user->isGuest): ?>
    <table style="width:100%;" cellspacing="0" cellpadding="0" class="header-menu">
        <tbody>
        <tr>
            <td style="width: 10%;">
                <a href="#" class="header-link float-l">
                    <img width="24" height="24" alt="ref" src="/images/header/refresh_white2.png">
                </a>
            </td>
            <td style="width: 80%;" class="header-content">
                <div class="inline">
                    <div class="header-item">
                        <img src="/images/header/money_36.png" width="18" height="18" alt="$">
                        <span id="money"><?php echo Rounding:: Number(Yii::$app->user->identity->money); ?></span>
                        /
                        <span id="income"><?php echo Rounding:: Number(User:: Income()); ?> </span>
                        <span> (в сек.)</span>
                    </div>
                    <div class="header-item">
                        <img src="/images/ruby.png" width="18" height="18" alt="ruby">
                        <span>
                            <?php echo number_format(Yii::$app->user->identity->ruby); ?>
                        </span>
                    </div>
                </div>
            </td>
            <td style="width: 10%;">
                <a id="id3" href="/user/mail/" class="header-link float-r">
                    <img id="mail"
                         src="/images/header/<?php echo User:: Mail() ? 'mail_new' : 'mail_white'; ?>.png" alt="почта"
                         width="24" height="24">
                </a>
            </td>

            <td style="width: 52px;">

            </td>
        </tr>
        </tbody>
    </table>
<?php endif; ?>


<a class="leprechaun" style="display:none;" onclick="key();"><h1></span> <i class="fa fa-key"
                                                                            style="color:#9edcdb;"></i></h1></a>
<div style="display:none;" class="key"><h2>+<span id="count-key"></span> <i class="fa fa-key"></i></h2></div>
<?php echo !User::Block() ? $content : User:: Block(); ?>

<?php if (!Yii::$app->user->isGuest): ?>
    <div class="content text-center">
        <div class="container">
            <div class="footer-nav">
                <div class="row">
                    <div class="col footer-nav-link">
                        <a href="/"><img src="/images/foot/index.png" class="u-m" width="64px;"
                                         height="64px;">
                        </a>
                        <a href="/" class="bottom-link">Бизнесы</a>
                    </div>
                    <div class="col footer-nav-link">
                        <a href="/user/<?php echo Yii::$app->user->identity->id; ?>"><img
                                    src="/images/avatar/user/<?php echo Yii::$app->user->identity->sex; ?>/<?php echo Yii::$app->user->identity->avatar; ?>.png"
                                    class="u-m" width="64px;" height="64px;">
                        </a>
                        <a href="/user/<?php echo Yii::$app->user->identity->id; ?>"  class="bottom-link">
                            Профиль
                        </a>
                    </div>
                    <div class="col footer-nav-link">
                        <a href="<?php echo Yii::$app->user->identity->corp == 0 ? '/corp/rating' : '/corp/' . Yii::$app->user->identity->corp; ?>"><img
                                    src="/images/foot/orden.png" class="u-m" width="64px;" height="64px;"></a>
                        <a href="<?php echo Yii::$app->user->identity->corp == 0 ? '/corp/rating' : '/corp/' . Yii::$app->user->identity->corp; ?>"  class="bottom-link">
                            Корпорация
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <?php if (Yii::$app->user->identity->role == 2): ?>
            <div class="content text-center">
                <div class="blocks">
                    <a class="btnl" href="/admin"><span><span>Админ-Панель</span></span>
                    </a>
                </div>
            </div>
        <?php endif; ?>
    <div class="content text-center">
        <div class="promo-block">
            <span class="promo-block-name">Акция</span>
            <div class="promo-block-content">
                <?php echo \app\models\active\Action:: Current(); ?>
            </div>
        </div>
    </div>
    <div class="footer-links">
        <a href="/forum"> Новости</a> <br>
        <a href="/user/admin"> Тех. Поддержка</a> |
        <a href="/chat"> Чат</a> |
        <a href="/user/online">Онлайн</a>: <?php echo User:: OnlineCount(); ?>
    </div>
<?php endif; ?>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
