<?php

use yii\helpers\Html;
use app\models\User;
use app\models\active\Corp;


$this->title = Html:: encode($corp->name);

?>

    <center>
    	<div class="content">
    		<div class="blocks">

        <a href="<?php $corp->id == Yii::$app->user->identity->corp ? '/corp/gerb' : '#'; ?>"><img

                    src="/images/corp/<?php echo $corp->gerb; ?>.png" style="border-radius: 10px; width: 100%; vertical-align: center; padding-top: 3px;" height="160"
                    ></a>
    </div>
    	</div> 
 
    	
        <div class="feedback">Корпорация «<?php echo $this->title; ?>»
            <br>Кубки <img src="/images/cup.png" width="13px" style="vertical-align: middle;"> <?php echo $corp->cup; ?></div>
        
        
        
        <div class="feedback">
        <?php if (Yii::$app->user->identity->corp == $corp->id): ?>
        	Склад <img src="/images/ruby.png" alt="*" width="13px" height="13px"/><?php echo $corp->ruby; ?>
        </br>
        <?php endif; ?>
        К доходу + <?php echo $corp->statue * 20; ?> %
		<?php if (!empty($corp->status)): ?>
		<br>
            <?php echo Html:: encode($corp->status); ?>
            <?php endif; ?>
            <?php if ($corp->card > time()): ?><br>
            <span style="color:yellow;">Корпоративная карта активирована</span>
            <br>
            <?php echo \app\commands\Rounding:: Number($corp->card - time(), 0, 3); ?>
		<?php endif; ?>
	</center></div></div>
    <div class="content">
    
<?php if (Yii::$app->user->identity->corp == $corp->id): ?>
    <div class="blocks">
        <a class="btnl mt4"
           href="/chat?type=corp"><img src="/images/icons/chat.png" alt="*" width="20"
                                       height="20"/> Чат</a>
    </div>


    <div class="blocks">
        <a class="btnl mt4"
           href="/corp/statue"> Статуя <?php echo $corp->statue; ?> уровень</a>
    </div>
<?php endif; ?>
<?php if (Yii::$app->user->identity->position >= 3 && $corp->id == Yii::$app->user->identity->corp): ?>

    <div class="blocks">
        <a class="btnl mt4 card-active"
           href="javascript:void(0);" onclick="cardActive();"> Активировать корпоративную карту 5k <img
                    src="/images/ruby.png" width="20"></a>
    </div>

<?php endif; ?>


    <div class="blocks">
        <a class="btnl mt4"
           href="" class="btn"><img src="/images/arrow_down2.png" alt="*"
                                    width="20" height="20"/> Состав корпорации
            <?php echo $count; ?> / <?php echo $corp->vacancy; ?></a>
    </div>
    <div class="block">
        <div class="comm_answer_main">
            <div class="corp-user">
            <?php echo User:: findUser($corp->user); ?> - Владелец, <img src="/images/cup.png" width="20">
            <?php echo \app\commands\Rounding:: Number(User:: findOne($corp->user)->cup); ?>
            </div>

            <?php foreach ($users as $res): ?>
                <br>
                <div class="corp-user">
                <?php echo User:: findUser($res['id']); ?> - <?php echo Corp:: Position($res['position']); ?>, <img
                        src="/images/cup.png" width="20">
                <?php echo \app\commands\Rounding:: Number($res['cup']); ?>
                </div>


                <?php if (Yii::$app->user->identity->corp == $corp->id): ?>
                    <?php if (Yii::$app->user->identity->id == $corp->user || Yii::$app->user->identity->position >= 3): ?>
                        <a href="javascript:void(0);" class="btn" onclick="deleteUser('<?php echo $res['id']; ?>');">
                            <i class="fa fa-times" data-placement="top" data-toggle="tooltip"
                               data-original-title="Удалить <?php echo Html:: encode($res['username'] ?? 'Гость' . $res['id']); ?> из корпорации"></i>
                        </a>

                        <a href="/corp/user-setting?id=<?php echo $res['id']; ?>" class="btn">
                            <i class="fa fa-cog"></i>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>


            <?php endforeach; ?>
        </div>
    </div>

<?php if (Yii::$app->user->identity->corp == $corp->id): ?>
    <div class="blocks">
        <a class="btnl mt4" href="/corp/treasury"
           class="btn"><img src="/images/ruby.png" alt="*" width="20"
                            height="20"/> Пополнить склад корпорации</a>
    </div>

    <?php if (Yii::$app->user->identity->position >= 3): ?>

        <div class="blocks">
            <a
                    class="btnl mt4" href="/corp/notice" class="btn"><img src="/images/header/mail_white.png" alt="*"
                                                                          width="20"
                                                                          height="20"/> Рассылка сообщений</a>
        </div>
        <div class="blocks">
            <a
                    class="btnl mt4" href="/corp/setting"
                    class="btn"> Настройки</a>
        </div>

        <?php if ($corp->vacancy < 30): ?>
            <div class="blocks">
                <a class="btnl mt4 vacancy-up" href="javascript:void(0);"
                   class="btn"> Купить место (<?php echo $corp->vacancy + 1; ?>) <img
                            src="/images/ruby.png" alt="*" width="20"
                            height="20"/> <?php echo ($corp->vacancy + 1) * 200; ?></a>
            </div>

        <?php endif; ?>
        </div>

        <div class="content">

            <div class="blocks">
                <a
                        class="btnl mt4 delete-corp" href="javascript:void(0);"> Удалить корпорацию</a>
            </div>
        </div>
    <?php else: ?>
        <div class="content">
            <div class="blocks">
                <a
                        class="btnl mt4 exit-corp" href="javascript:void(0);"> Покинуть корпорацию</a>
            </div>
        </div>

    <?php endif; ?>
<?php endif; ?>
    </div>
<?php
$script = <<< JS

     function cardActive()
    {





        swal({
    title: "Активировать корпоративную карту",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/corp-card-active', function(data) {


		});

		location.reload();
      }
    }
  );


    }



    function deleteUser(user)
    {





        swal({
    title: "Удалить игрока из корпорации?",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/delete-user?user_id='+user, function(data) {


		});

		location.reload();
      }
    }
  );


    }


	$('.vacancy-up').on( "click", function() {


	swal({
    title: "Купить место?",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/vacancy-up', function(data) {

			swal(data.title,  '',  data.status);
			setTimeout(function(){
				location.reload();
			}, 1000);

		});
      }
    }
  );


	});







	$('.delete-corp').on( "click", function() {


	swal({
    title: "Удалить корпорацию?",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/delete-corp', function(data) {

			swal(data.title,  '',  data.status);
			setTimeout(function(){
				location.reload();
			}, 1000);

		});
      }
    }
  );


	});



	$('.exit-corp').on( "click", function() {


	swal({
    title: "Покинуть корпорацию?",
    text: "",
    buttons: {
      text: "Да",
      cancel: "Нет"
    }
  }).then(
     function(isConfirm) {
      if(isConfirm){
       $.getJSON('/ajax/exit-corp', function(data) {

			swal(data.title,  '',  data.status);
			setTimeout(function(){
				location.reload();
			}, 1000);

		});
      }
    }
  );


	});

JS;

$this->registerJs($script, $this::POS_END);