<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class StyleChange extends Model
{
    public $style;


    public function rules()
    {
        return [

            [['style'], 'required', 'message' => 'Необходимо выбрать стиль'],
            ['style', 'in', 'range' => ['site', 'dark']]
        ];
    }


    public function attributeLabels()
    {

        return
            [
                'style' => 'Стиль',
            ];

    }

    public function change()
    {
        if ($this->validate()) {
            $user = User::findOne(Yii::$app->user->id);
            $user->style = $this->style;
            $user->save();

            return true;
        }
        return false;
    }

}
