<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use app\models\active\Corp;


class SettingCorp extends Model{
 
 public $name;
 public $status;
 
 
 public function rules() {
        return [
            [['name'], 'required'],
            ['name', 'string', 'length' => [2, 50]],
			['status', 'string', 'length' => [2, 150]],
			['name', 'validateCorp'],
        ];
    }
 
 public function attributeLabels() {
 return [
 'name' => 'Название',
 'status' => 'Статус',
 ];
 }
 
     public function validateCorp($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $corp = Corp :: find()->where(['name' => $this->name])->andWhere(['!=','user',Yii::$app->user->id])->count();

          
            if ($corp > 0) {
                $this->addError($attribute, 'Копрорация с таким названием уже существует');
            }
                
        }
    }

 

 
}