<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class PasswordChange extends Model
{
    public $password_old;
    public $password;

    private $_user = false;


    public function rules()
    {
        return [
            [['password_old', 'password'], 'required'],
            ['password_old', 'validatePassword'],
            ['password', 'string', 'length' => [8, 30]],
            
        ];
    }

 public function attributeLabels() {
 return [
 'password_old' => 'Текущий пароль',
 'password' => 'Новый пароль',
 ];
 }

   public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();

          
            if (!$user || !Yii::$app->getSecurity()->validatePassword($this->password_old, $user->password)) {
                $this->addError($attribute, 'Неверный пароль.');
            }
                
        }
    }


    public function getUser()
    {
        
        if ($this->_user === false) {
            $identity = User::findOne(['id' => Yii::$app->user->id]);
            $this->_user = User::findIdentity($identity);
        }

        return $this->_user;
    }


    public function change(){
        
        if ($this->validate()) {
        $user = $this->getUser();
        
        $hash = Yii::$app->getSecurity()->generatePasswordHash($this->password);
        
        $user->password = $hash;
        $user->save();
        
        return true;
        }
        
        return false;
    }
}