<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class NickChange extends Model
{
    public $username;
   


   
    public function rules()
    {
        return [
            
            [['username'], 'required', 'message' => 'Необходимо заполнить это поле'],
            ['username', 'unique', 'targetClass' => User::className(),  'message' => 'Игрок с этим логином уже зарегистрирован'],
            ['username', 'trim', 'isEmpty' => function ($value) {
                return trim($value);
            }],
            ['username', 'string', 'length' => [3, 20]],
			//['username', 'match', 'pattern' => '/^[A-Za-zА-Яа-яs, ]+$/u'],
            ['username', 'match', 'pattern' => '/^(?>\pL+ ?\b)+$/u']
        ];
    }
    
    
    public function attributeLabels()
	 {
		 
		 return 
		 [
		  'username' => 'Новый ник',
		 ];
		 
	 }
 
}
